/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessRecipeBuilder {
    private static final Logger field_200493_a = LogManager.getLogger();
    private final Item field_200494_b;
    private final int field_200495_c;
    private final List<Ingredient> field_200496_d = Lists.newArrayList();
    private final Advancement.Builder field_200497_e = Advancement.Builder.func_200278_a();
    private String field_200498_f;

    public ShapelessRecipeBuilder(IItemProvider iItemProvider, int n) {
        this.field_200494_b = iItemProvider.func_199767_j();
        this.field_200495_c = n;
    }

    public static ShapelessRecipeBuilder func_200486_a(IItemProvider iItemProvider) {
        return new ShapelessRecipeBuilder(iItemProvider, 1);
    }

    public static ShapelessRecipeBuilder func_200488_a(IItemProvider iItemProvider, int n) {
        return new ShapelessRecipeBuilder(iItemProvider, n);
    }

    public ShapelessRecipeBuilder func_203221_a(Tag<Item> tag) {
        return this.func_200489_a(Ingredient.func_199805_a(tag));
    }

    public ShapelessRecipeBuilder func_200487_b(IItemProvider iItemProvider) {
        return this.func_200491_b(iItemProvider, 1);
    }

    public ShapelessRecipeBuilder func_200491_b(IItemProvider iItemProvider, int n) {
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            this.func_200489_a(Ingredient.func_199804_a(iItemProvider));
        }
        return this;
    }

    public ShapelessRecipeBuilder func_200489_a(Ingredient ingredient) {
        return this.func_200492_a(ingredient, 1);
    }

    public ShapelessRecipeBuilder func_200492_a(Ingredient ingredient, int n) {
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            this.field_200496_d.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder func_200483_a(String string, ICriterionInstance iCriterionInstance) {
        this.field_200497_e.func_200275_a(string, iCriterionInstance);
        return this;
    }

    public ShapelessRecipeBuilder func_200490_a(String string) {
        this.field_200498_f = string;
        return this;
    }

    public void func_200482_a(Consumer<IFinishedRecipe> consumer) {
        this.func_200485_a(consumer, Registry.field_212630_s.func_177774_c(this.field_200494_b));
    }

    public void func_200484_a(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c(this.field_200494_b);
        if (new ResourceLocation(string).equals(resourceLocation)) {
            throw new IllegalStateException("Shapeless Recipe " + string + " should remove its 'save' argument");
        }
        this.func_200485_a(consumer, new ResourceLocation(string));
    }

    public void func_200485_a(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.func_200481_a(resourceLocation);
        this.field_200497_e.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", new RecipeUnlockedTrigger.Instance(resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c(resourceLocation)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(resourceLocation, this.field_200494_b, this.field_200495_c, this.field_200498_f == null ? "" : this.field_200498_f, this.field_200496_d, this.field_200497_e, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.field_200494_b.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void func_200481_a(ResourceLocation resourceLocation) {
        if (this.field_200497_e.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation field_200453_a;
        private final Item field_200454_b;
        private final int field_200455_c;
        private final String field_200456_d;
        private final List<Ingredient> field_200457_e;
        private final Advancement.Builder field_200458_f;
        private final ResourceLocation field_200459_g;

        public Result(ResourceLocation resourceLocation, Item item, int n, String string, List<Ingredient> list, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.field_200453_a = resourceLocation;
            this.field_200454_b = item;
            this.field_200455_c = n;
            this.field_200456_d = string;
            this.field_200457_e = list;
            this.field_200458_f = builder;
            this.field_200459_g = resourceLocation2;
        }

        @Override
        public void func_218610_a(JsonObject jsonObject2) {
            JsonObject jsonObject2;
            if (!this.field_200456_d.isEmpty()) {
                jsonObject2.addProperty("group", this.field_200456_d);
            }
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.field_200457_e) {
                jsonArray.add(ingredient.func_200304_c());
            }
            jsonObject2.add("ingredients", (JsonElement)jsonArray);
            \u2603 = new JsonObject();
            \u2603.addProperty("item", Registry.field_212630_s.func_177774_c(this.field_200454_b).toString());
            if (this.field_200455_c > 1) {
                \u2603.addProperty("count", (Number)this.field_200455_c);
            }
            jsonObject2.add("result", (JsonElement)\u2603);
        }

        @Override
        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        @Override
        public ResourceLocation func_200442_b() {
            return this.field_200453_a;
        }

        @Override
        @Nullable
        public JsonObject func_200440_c() {
            return this.field_200458_f.func_200273_b();
        }

        @Override
        @Nullable
        public ResourceLocation func_200443_d() {
            return this.field_200459_g;
        }
    }
}

