/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.BlockListReport;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.CommandsReport;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.EntityTypeTagsProvider;
import net.minecraft.data.FluidTagsProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.NBTToSNBTConverter;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.RegistryDumpReport;
import net.minecraft.data.SNBTToNBTConverter;
import net.minecraft.data.StructureUpdater;

public class Main {
    public static void main(String[] stringArray) throws IOException {
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec \u26032 = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder \u26033 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder \u26034 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder \u26035 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder \u26036 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder \u26037 = optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder \u26038 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet \u260311 = optionParser.parse(stringArray);
        if (\u260311.has((OptionSpec)\u26032) || !\u260311.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path \u260312 = Paths.get((String)\u26039.value(\u260311), new String[0]);
        boolean \u260313 = \u260311.has((OptionSpec)\u26038);
        boolean \u260314 = \u260313 || \u260311.has((OptionSpec)\u26034);
        boolean \u260315 = \u260313 || \u260311.has((OptionSpec)\u26033);
        boolean \u260316 = \u260313 || \u260311.has((OptionSpec)\u26035);
        boolean \u260317 = \u260313 || \u260311.has((OptionSpec)\u26036);
        boolean \u260318 = \u260313 || \u260311.has((OptionSpec)\u26037);
        DataGenerator \u260319 = Main.func_200264_a(\u260312, \u260311.valuesOf((OptionSpec)\u260310).stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList()), \u260314, \u260315, \u260316, \u260317, \u260318);
        \u260319.func_200392_c();
    }

    public static DataGenerator func_200264_a(Path path, Collection<Path> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        DataGenerator dataGenerator = new DataGenerator(path, collection);
        if (bl || bl2) {
            dataGenerator.func_200390_a(new SNBTToNBTConverter(dataGenerator).func_225369_a(new StructureUpdater()));
        }
        if (bl2) {
            dataGenerator.func_200390_a(new FluidTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new BlockTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new ItemTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new EntityTypeTagsProvider(dataGenerator));
            dataGenerator.func_200390_a(new RecipeProvider(dataGenerator));
            dataGenerator.func_200390_a(new AdvancementProvider(dataGenerator));
            dataGenerator.func_200390_a(new LootTableProvider(dataGenerator));
        }
        if (bl3) {
            dataGenerator.func_200390_a(new NBTToSNBTConverter(dataGenerator));
        }
        if (bl4) {
            dataGenerator.func_200390_a(new BlockListReport(dataGenerator));
            dataGenerator.func_200390_a(new RegistryDumpReport(dataGenerator));
            dataGenerator.func_200390_a(new CommandsReport(dataGenerator));
        }
        return dataGenerator;
    }
}

