/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocalLocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class BlockPosArgument
implements ArgumentType<ILocationArgument> {
    private static final Collection<String> field_201333_c = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType field_197278_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.pos.unloaded", new Object[0]));
    public static final SimpleCommandExceptionType field_197279_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.pos.outofworld", new Object[0]));

    public static BlockPosArgument func_197276_a() {
        return new BlockPosArgument();
    }

    public static BlockPos func_197273_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        BlockPos blockPos = ((ILocationArgument)commandContext.getArgument(string, ILocationArgument.class)).func_197280_c((CommandSource)commandContext.getSource());
        if (!((CommandSource)commandContext.getSource()).func_197023_e().func_175667_e(blockPos)) {
            throw field_197278_b.create();
        }
        ((CommandSource)commandContext.getSource()).func_197023_e();
        if (!ServerWorld.func_175701_a(blockPos)) {
            throw field_197279_c.create();
        }
        return blockPos;
    }

    public static BlockPos func_197274_b(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((ILocationArgument)commandContext.getArgument(string, ILocationArgument.class)).func_197280_c((CommandSource)commandContext.getSource());
    }

    public ILocationArgument parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '^') {
            return LocalLocationArgument.func_200142_a(stringReader);
        }
        return LocationInput.func_200148_a(stringReader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        if (commandContext.getSource() instanceof ISuggestionProvider) {
            String string = suggestionsBuilder.getRemaining();
            Collection<ISuggestionProvider.Coordinates> \u26032 = !string.isEmpty() && string.charAt(0) == '^' ? Collections.singleton(ISuggestionProvider.Coordinates.field_209004_a) : ((ISuggestionProvider)commandContext.getSource()).func_217294_q();
            return ISuggestionProvider.func_209000_a(string, \u26032, suggestionsBuilder, Commands.func_212590_a(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return field_201333_c;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

