/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openzen.zenscript.lexer.CharStream;
import org.openzen.zenscript.lexer.CompiledDFA;
import org.openzen.zenscript.lexer.DFA;

public class NFA<T extends Comparable<T>> {
    public static final int EPSILON = -2147483647;
    private final NFAState<T> initial;
    private final Class<T> tokenClass;
    private HashMap<NodeSet, DFA.DFAState<T>> converted;

    public NFA(Class<T> tokenClass, NFAState<T> initial) {
        this.initial = initial;
        this.tokenClass = tokenClass;
    }

    public NFA(String regexp, T state) {
        this.tokenClass = state.getClass();
        Partial<T> main = this.processRegExp(new CharStream(regexp));
        this.initial = new NFAState();
        this.initial.addTransition(((Partial)main).tailLabel, ((Partial)main).tail);
        ((Partial)main).head.setFinal(state);
    }

    public NFA(String[] regexp, T[] finals) {
        this.tokenClass = finals[0].getClass();
        this.initial = new NFAState();
        for (int i = 0; i < regexp.length; ++i) {
            if (regexp[i] == null) continue;
            try {
                Partial<T> partial = this.processRegExp(new CharStream(regexp[i]));
                ((Partial)partial).head.setFinal(finals[i]);
                this.initial.addTransition(((Partial)partial).tailLabel, ((Partial)partial).tail);
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Error parsing " + regexp[i], ex);
            }
        }
    }

    public NFA(List<String> regexp, List<T> finals, Class<T> tokenClass) {
        this.tokenClass = tokenClass;
        this.initial = new NFAState();
        for (int i = 0; i < regexp.size(); ++i) {
            if (regexp.get(i) == null) continue;
            Partial<T> partial = this.processRegExp(new CharStream(regexp.get(i)));
            ((Partial)partial).head.setFinal(finals.get(i));
            this.initial.addTransition(((Partial)partial).tailLabel, ((Partial)partial).tail);
        }
    }

    public DFA<T> toDFA() {
        this.converted = new HashMap();
        HashSet closure = new HashSet();
        ((NFAState)this.initial).closure(closure);
        DFA.DFAState<T> init = this.convert(new NodeSet(closure));
        return new DFA<T>(this.tokenClass, init);
    }

    public CompiledDFA<T> compile() {
        return this.toDFA().optimize().compile();
    }

    /*
     * WARNING - void declaration
     */
    private DFA.DFAState<T> convert(NodeSet nodes) {
        if (!this.converted.containsKey(nodes)) {
            void var7_14;
            DFA.DFAState<T> node = new DFA.DFAState<T>();
            this.converted.put(nodes, node);
            HashSet edgeSet = new HashSet();
            for (NFAState nFAState : nodes.nodes) {
                nFAState.alphabet(edgeSet);
            }
            Iterator iterator = edgeSet.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                HashSet edge = new HashSet();
                for (NFAState n : nodes.nodes) {
                    n.edge(i, edge);
                }
                NodeSet nodeSet = new NodeSet(edge);
                node.addTransition(i, this.convert(nodeSet));
            }
            Comparable finalCode = null;
            NFAState[] nFAStateArray = nodes.nodes;
            int n = nFAStateArray.length;
            boolean bl = false;
            while (var7_14 < n) {
                NFAState n2 = nFAStateArray[var7_14];
                if (n2.state != null) {
                    finalCode = finalCode != null ? (((Comparable)n2.state).compareTo(finalCode) < 0 ? (Comparable)n2.state : finalCode) : (Comparable)n2.state;
                }
                ++var7_14;
            }
            node.setFinal(finalCode);
            return node;
        }
        return this.converted.get(nodes);
    }

    private Partial<T> processRegExp(CharStream stream) {
        Partial<T> partial = this.processRegExp0(stream);
        if (stream.optional('|')) {
            ArrayList<Partial<T>> partials = new ArrayList<Partial<T>>();
            partials.add(partial);
            partials.add(this.processRegExp0(stream));
            while (stream.optional('|')) {
                partials.add(this.processRegExp0(stream));
            }
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            for (Partial partial2 : partials) {
                tail.addTransition(partial2.tailLabel, partial2.tail);
                partial2.head.addTransition(-2147483647, head);
            }
            return new Partial(-2147483647, tail, head);
        }
        return partial;
    }

    private Partial<T> processRegExp0(CharStream stream) {
        Partial<T> partial = this.processRegExp1(stream);
        while (!stream.peek(')') && !stream.peek('|') && stream.hasMore()) {
            Partial<T> partial2 = this.processRegExp1(stream);
            ((Partial)partial).head.addTransition(((Partial)partial2).tailLabel, ((Partial)partial2).tail);
            partial = new Partial(((Partial)partial).tailLabel, ((Partial)partial).tail, ((Partial)partial2).head);
        }
        return partial;
    }

    private Partial<T> processRegExp1(CharStream stream) {
        Partial<T> partial = this.processPartial(stream);
        if (stream.optional('*')) {
            NFAState node = new NFAState();
            ((Partial)partial).head.addTransition(-2147483647, node);
            node.addTransition(((Partial)partial).tailLabel, ((Partial)partial).tail);
            return new Partial(-2147483647, node, node);
        }
        if (stream.optional('+')) {
            NFAState node = new NFAState();
            ((Partial)partial).head.addTransition(-2147483647, node);
            node.addTransition(((Partial)partial).tailLabel, ((Partial)partial).tail);
            return new Partial(((Partial)partial).tailLabel, ((Partial)partial).tail, node);
        }
        if (stream.optional('?')) {
            NFAState node = new NFAState();
            node.addTransition(-2147483647, ((Partial)partial).head);
            node.addTransition(((Partial)partial).tailLabel, ((Partial)partial).tail);
            return new Partial(-2147483647, node, ((Partial)partial).head);
        }
        if (stream.optional('{')) {
            int i;
            int amount = this.processInt(stream);
            if (amount < 0) {
                throw new IllegalArgumentException("Repitition count expected");
            }
            if (stream.optional(',')) {
                int i2;
                int amount2 = this.processInt(stream);
                stream.required('}');
                if (amount2 < 0) {
                    int i3;
                    Partial[] duplicates = new Partial[amount];
                    for (i3 = 0; i3 < duplicates.length - 1; ++i3) {
                        duplicates[i3] = partial.duplicate();
                    }
                    duplicates[amount - 1] = partial;
                    for (i3 = 0; i3 < duplicates.length - 1; ++i3) {
                        duplicates[i3].head.addTransition(duplicates[i3 + 1].tailLabel, duplicates[i3 + 1].tail);
                    }
                    duplicates[amount - 1].head.addTransition(duplicates[amount - 1].tailLabel, duplicates[amount - 1].tail);
                    return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount - 1].head);
                }
                Partial[] duplicates = new Partial[amount2];
                for (i2 = 0; i2 < duplicates.length - 1; ++i2) {
                    duplicates[i2] = partial.duplicate();
                }
                duplicates[amount2 - 1] = partial;
                for (i2 = 0; i2 < duplicates.length - 1; ++i2) {
                    duplicates[i2].head.addTransition(duplicates[i2 + 1].tailLabel, duplicates[i2 + 1].tail);
                }
                for (i2 = amount; i2 < amount2; ++i2) {
                    if (i2 == 0) {
                        NFAState additional = new NFAState();
                        additional.addTransition(duplicates[0].tailLabel, duplicates[0].tail);
                        additional.addTransition(-2147483647, duplicates[amount2 - 1].head);
                        duplicates[0].tailLabel = -2147483647;
                        duplicates[0].tail = additional;
                        continue;
                    }
                    duplicates[i2 - 1].head.addTransition(-2147483647, duplicates[amount2 - 1].head);
                }
                return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount2 - 1].head);
            }
            stream.required('}');
            Partial[] duplicates = new Partial[amount];
            for (i = 0; i < duplicates.length - 1; ++i) {
                duplicates[i] = partial.duplicate();
            }
            duplicates[amount - 1] = partial;
            for (i = 0; i < duplicates.length - 1; ++i) {
                duplicates[i].head.addTransition(duplicates[i + 1].tailLabel, duplicates[i + 1].tail);
            }
            return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount - 1].head);
        }
        return partial;
    }

    private Partial<T> processPartial(CharStream stream) {
        if (stream.optional('(')) {
            Partial<T> result = this.processRegExp(stream);
            stream.required(')');
            return result;
        }
        if (stream.optional('[')) {
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            Iterator<Integer> iter = this.processCharList(stream).iterator();
            while (iter.hasNext()) {
                tail.addTransition(iter.next(), head);
            }
            stream.required(']');
            return new Partial(-2147483647, tail, head);
        }
        if (stream.optional('.')) {
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            for (int i = 0; i <= 256; ++i) {
                tail.addTransition(i, head);
            }
            return new Partial(-2147483647, tail, head);
        }
        NFAState node = new NFAState();
        return new Partial(this.processChar(stream), node, node);
    }

    private Set<Integer> processCharList(CharStream stream) {
        boolean invert = stream.optional('^');
        HashSet<Integer> base = new HashSet<Integer>();
        do {
            this.processCharPartial(base, stream);
        } while (!stream.peek(']'));
        if (invert) {
            HashSet<Integer> result = new HashSet<Integer>();
            for (int i = 0; i <= 256; ++i) {
                if (base.contains(i)) continue;
                result.add(i);
            }
            return result;
        }
        return base;
    }

    private void processCharPartial(Set<Integer> out, CharStream stream) {
        if (stream.optional('.')) {
            for (int i = 0; i <= 256; ++i) {
                out.add(i);
            }
        } else {
            int from = this.processChar(stream);
            if (stream.optional('-')) {
                int to = this.processChar(stream);
                for (int i = from; i <= to; ++i) {
                    out.add(i);
                }
            } else {
                out.add(from);
            }
        }
    }

    private int processChar(CharStream stream) {
        if (stream.optional('\\')) {
            char c = stream.next();
            switch (c) {
                case 'e': {
                    return -1;
                }
                case 'r': {
                    return 13;
                }
                case 'n': {
                    return 10;
                }
                case 't': {
                    return 9;
                }
                case '[': {
                    return 91;
                }
                case ']': {
                    return 93;
                }
                case '(': {
                    return 40;
                }
                case ')': {
                    return 41;
                }
                case '.': {
                    return 46;
                }
                case '+': {
                    return 43;
                }
                case '-': {
                    return 45;
                }
                case '\\': {
                    return 92;
                }
                case '{': {
                    return 123;
                }
                case '}': {
                    return 125;
                }
                case '?': {
                    return 63;
                }
                case '*': {
                    return 42;
                }
                case '~': {
                    return 126;
                }
                case '|': {
                    return 124;
                }
                case '^': {
                    return 94;
                }
            }
            throw new IllegalArgumentException("Invalid character: " + (char)c);
        }
        char c = stream.next();
        switch (c) {
            case '(': 
            case ')': 
            case '*': 
            case '.': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                throw new IllegalArgumentException("Invalid character: " + (char)c);
            }
        }
        return c;
    }

    private int processInt(CharStream stream) {
        int data = stream.optional('0', '9') - 48;
        if (data < 0) {
            return -1;
        }
        char ch = stream.optional('0', '9');
        while (ch != '\u0000') {
            data = data * 10 + (ch - 48);
            ch = stream.optional('0', '9');
        }
        return data;
    }

    private static class Partial<T> {
        private int tailLabel;
        private NFAState<T> tail;
        private NFAState<T> head;

        public Partial(int tailLabel, NFAState<T> tail, NFAState<T> head) {
            this.tailLabel = tailLabel;
            this.tail = tail;
            this.head = head;
        }

        public Partial<T> duplicate() {
            HashMap nodes = new HashMap();
            LinkedList<NFAState> todo = new LinkedList<NFAState>();
            todo.add(this.tail);
            nodes.put(this.tail, new NFAState());
            while (!todo.isEmpty()) {
                NFAState node = (NFAState)todo.poll();
                for (NFAState.Transition t : node.transitions) {
                    if (!nodes.containsKey(t.next)) {
                        nodes.put(t.next, new NFAState());
                        todo.add(t.next);
                    }
                    ((NFAState)nodes.get(node)).addTransition(t.label, (NFAState)nodes.get(t.next));
                }
            }
            return new Partial<T>(this.tailLabel, (NFAState)nodes.get(this.tail), (NFAState)nodes.get(this.head));
        }
    }

    private class NodeSet {
        private NFAState<T>[] nodes;

        public NodeSet(HashSet<NFAState<T>> nodes) {
            this.nodes = new NFAState[nodes.size()];
            int i = 0;
            for (NFAState node : nodes) {
                this.nodes[i++] = node;
            }
            Arrays.sort(this.nodes, (o1, o2) -> ((NFAState)o1).index - ((NFAState)o2).index);
        }

        public int hashCode() {
            return Arrays.hashCode(this.nodes);
        }

        public boolean equals(Object other) {
            if (other.getClass() != NodeSet.class) {
                return false;
            }
            return Arrays.equals(this.nodes, ((NodeSet)other).nodes);
        }
    }

    public static class NFAState<T> {
        private static int counter = 1;
        private ArrayList<Transition> transitions = new ArrayList();
        private ArrayList<NFAState<T>> closure;
        private int index = counter++;
        private T state;

        public void addTransition(int label, NFAState<T> next) {
            this.transitions.add(new Transition(label, next));
        }

        public void setFinal(T finalCode) {
            if (this.state == finalCode) {
                return;
            }
            this.state = finalCode;
            for (Transition t : this.transitions) {
                if (t.label != -2147483647) continue;
                t.next.setFinal(finalCode);
            }
        }

        private void closure(HashSet<NFAState<T>> output) {
            for (NFAState<T> node : this.closure()) {
                output.add(node);
            }
        }

        private ArrayList<NFAState<T>> closure() {
            if (this.closure == null) {
                this.closure = new ArrayList();
                HashSet<NFAState<T>> tmp = new HashSet<NFAState<T>>();
                tmp.add(this);
                for (Transition transition : this.transitions) {
                    if (transition.label != -2147483647 || tmp.contains(transition.next)) continue;
                    tmp.add(transition.next);
                    transition.next.closure(tmp);
                }
                for (NFAState nFAState : tmp) {
                    this.closure.add(nFAState);
                }
            }
            return this.closure;
        }

        private void edge(int label, HashSet<NFAState<T>> output) {
            for (Transition transition : this.transitions) {
                if (transition.label != label || output.contains(transition.next)) continue;
                output.add(transition.next);
                transition.next.closure(output);
            }
        }

        private void alphabet(HashSet<Integer> output) {
            for (NFAState<T> node : this.closure()) {
                for (Transition t : node.transitions) {
                    if (t.label == -2147483647) continue;
                    output.add(t.label);
                }
            }
        }

        private class Transition {
            private int label;
            private NFAState<T> next;

            public Transition(int input, NFAState<T> next) {
                this.label = input;
                this.next = next;
            }
        }
    }
}

