/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.storage;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.codemodel.type.storage.InvalidStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageType;

public interface StorageTag {
    public StorageType getType();

    public boolean canCastTo(StorageTag var1);

    public boolean canCastFrom(StorageTag var1);

    public boolean isDestructible();

    public boolean isConst();

    public boolean isImmutable();

    public static StorageTag union(CodePosition position, StorageTag minor, StorageTag major) {
        if (minor == AutoStorageTag.INSTANCE || minor == null) {
            return major;
        }
        if (major == AutoStorageTag.INSTANCE || major == null) {
            return minor;
        }
        if (!minor.equals(major)) {
            return new InvalidStorageTag(position, CompileExceptionCode.TYPE_CANNOT_UNITE, "Could not unite storage types: " + minor + " and " + major);
        }
        return major;
    }
}

