/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.definition.AliasDefinition;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.StructDefinition;
import org.openzen.zenscript.codemodel.definition.VariantDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class DefinitionTypeID
implements TypeID {
    public final HighLevelDefinition definition;
    public final StoredType[] typeArguments;
    public final DefinitionTypeID outer;
    private TypeID normalized;
    public TypeID superType;

    public DefinitionTypeID(GlobalTypeRegistry typeRegistry, HighLevelDefinition definition, StoredType[] typeArguments) {
        this(typeRegistry, definition, typeArguments, null);
    }

    public DefinitionTypeID(GlobalTypeRegistry typeRegistry, HighLevelDefinition definition, StoredType[] typeArguments, DefinitionTypeID outer) {
        if (typeArguments == null) {
            throw new NullPointerException("typeParameters cannot be null");
        }
        if (typeArguments.length != definition.getNumberOfGenericParameters()) {
            throw new IllegalArgumentException("Wrong number of type parameters! " + definition.name + " expected: " + definition.getNumberOfGenericParameters() + " got: " + typeArguments.length);
        }
        if (definition.isInnerDefinition() && !definition.isStatic() && outer == null) {
            throw new IllegalArgumentException("Inner definition requires outer instance");
        }
        if ((!definition.isInnerDefinition() || definition.isStatic()) && outer != null) {
            throw new IllegalArgumentException("Static inner definition must not have outer instance");
        }
        this.definition = definition;
        this.typeArguments = typeArguments;
        this.outer = outer;
        TypeID typeID = this.normalized = this.isDenormalized() ? this.normalize(typeRegistry) : this;
        if (this.normalized instanceof DefinitionTypeID && ((DefinitionTypeID)this.normalized).isDenormalized()) {
            throw new AssertionError();
        }
    }

    private boolean isDenormalized() {
        if (this.definition instanceof AliasDefinition) {
            return true;
        }
        for (StoredType typeArgument : this.typeArguments) {
            if (typeArgument.getNormalized().equals(typeArgument)) continue;
            return true;
        }
        return this.outer != null && !this.outer.getNormalized().equals(this.outer);
    }

    private TypeID normalize(GlobalTypeRegistry typeRegistry) {
        if (this.definition instanceof AliasDefinition) {
            AliasDefinition alias = (AliasDefinition)this.definition;
            if (alias.type == null) {
                throw new IllegalStateException("Alias type not yet initialized!");
            }
            HashMap<TypeParameter, StoredType> typeMapping = new HashMap<TypeParameter, StoredType>();
            for (int i = 0; i < this.definition.typeParameters.length; ++i) {
                typeMapping.put(this.definition.typeParameters[i], this.typeArguments[i].getNormalized());
            }
            GenericMapper mapper = new GenericMapper(this.definition.position, typeRegistry, typeMapping);
            TypeID result = alias.type.instance((GenericMapper)mapper, null).type.getNormalized();
            return result;
        }
        StoredType[] normalizedTypeParameters = new StoredType[this.typeArguments.length];
        for (int i = 0; i < normalizedTypeParameters.length; ++i) {
            normalizedTypeParameters[i] = this.typeArguments[i].getNormalized();
        }
        return typeRegistry.getForDefinition(this.definition, normalizedTypeParameters, this.outer == null ? null : (DefinitionTypeID)this.outer.getNormalized());
    }

    public boolean hasTypeParameters() {
        return this.typeArguments.length > 0;
    }

    public Map<TypeParameter, StoredType> getTypeParameterMapping() {
        HashMap<TypeParameter, StoredType> mapping = new HashMap<TypeParameter, StoredType>();
        DefinitionTypeID current = this;
        do {
            if (current.typeArguments == null) continue;
            if (current.definition.typeParameters == null) {
                System.out.println("Type parameters but no generic parameters");
                continue;
            }
            for (int i = 0; i < current.typeArguments.length; ++i) {
                mapping.put(current.definition.typeParameters[i], current.typeArguments[i]);
            }
        } while ((current = current.outer) != null && !current.definition.isStatic());
        return mapping;
    }

    public DefinitionTypeID(HighLevelDefinition definition) {
        this.definition = definition;
        this.typeArguments = StoredType.NONE;
        this.superType = definition.getSuperType();
        this.outer = null;
    }

    @Override
    public TypeID getNormalized() {
        return this.normalized;
    }

    @Override
    public StoredType instance(GenericMapper mapper, StorageTag storage) {
        if (!this.hasTypeParameters() && this.outer == null) {
            return this.stored(storage);
        }
        if (mapper == null || mapper.getMapping().isEmpty()) {
            return this.stored(storage);
        }
        if (mapper.registry == null) {
            throw new NullPointerException();
        }
        StoredType[] instancedArguments = StoredType.NONE;
        if (this.hasTypeParameters()) {
            instancedArguments = new StoredType[this.typeArguments.length];
            for (int i = 0; i < this.typeArguments.length; ++i) {
                instancedArguments[i] = this.typeArguments[i].instance(mapper);
            }
        }
        DefinitionTypeID instancedOuter = this.outer == null ? null : (DefinitionTypeID)this.outer.instance((GenericMapper)mapper, (StorageTag)storage).type;
        return mapper.registry.getForDefinition(this.definition, instancedArguments, instancedOuter).stored(storage);
    }

    @Override
    public TypeID getSuperType(GlobalTypeRegistry registry) {
        return this.definition.getSuperType() == null ? null : this.definition.getSuperType().instance((GenericMapper)new GenericMapper((CodePosition)this.definition.position, (GlobalTypeRegistry)registry, this.getTypeParameterMapping()), null).type;
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitDefinition(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitDefinition(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return this.definition instanceof StructDefinition || this.definition instanceof EnumDefinition;
    }

    @Override
    public boolean isEnum() {
        return this.definition instanceof EnumDefinition;
    }

    @Override
    public boolean isVariant() {
        return this.definition instanceof VariantDefinition;
    }

    @Override
    public boolean isDestructible() {
        return this.definition.isDestructible();
    }

    @Override
    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return this.definition.isDestructible(scanning);
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        if (this.hasTypeParameters()) {
            for (StoredType typeArgument : this.typeArguments) {
                if (!typeArgument.type.hasInferenceBlockingTypeParameters(parameters)) continue;
                return true;
            }
        }
        return this.superType != null && this.superType.hasInferenceBlockingTypeParameters(parameters);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.definition.hashCode();
        hash = 97 * hash + Arrays.deepHashCode(this.typeArguments);
        hash = 97 * hash + Objects.hashCode(this.outer);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefinitionTypeID other = (DefinitionTypeID)obj;
        return this.definition == other.definition && Arrays.deepEquals(this.typeArguments, other.typeArguments) && Objects.equals(this.outer, this.outer);
    }

    public String toString() {
        if (!this.hasTypeParameters() && this.outer == null) {
            return this.definition.name;
        }
        StringBuilder result = new StringBuilder();
        if (this.outer != null) {
            result.append(this.outer.toString()).append('.');
        }
        result.append(this.definition.name);
        result.append('<');
        for (int i = 0; i < this.typeArguments.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.typeArguments[i].toString());
        }
        result.append('>');
        return result.toString();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.definition.hasEmptyConstructor();
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        for (StoredType type : this.typeArguments) {
            type.type.extractTypeParameters(typeParameters);
        }
    }

    public DefinitionTypeID getInnerType(GenericName name, GlobalTypeRegistry registry) {
        HighLevelDefinition type = this.definition.getInnerType(name.name);
        return registry.getForDefinition(type, name.arguments, this);
    }
}

