/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CapturedExpression;
import org.openzen.zenscript.codemodel.expression.CapturedExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.expression.LambdaClosure;
import org.openzen.zenscript.codemodel.scope.TypeScope;

public class CapturedDirectExpression
extends CapturedExpression {
    public final Expression value;

    public CapturedDirectExpression(CodePosition position, LambdaClosure closure, Expression value) {
        super(position, value.type, closure);
        this.value = value;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitCapturedDirect(this);
    }

    @Override
    public <T> T accept(CapturedExpressionVisitor<T> visitor) {
        return visitor.visitCapturedDirect(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitCapturedDirect(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tValue = transformer.transform(this.value);
        return tValue == this.value ? this : new CapturedDirectExpression(this.position, this.closure, tValue);
    }

    @Override
    public CapturedExpression normalize(TypeScope scope) {
        return new CapturedDirectExpression(this.position, this.closure, this.value.normalize(scope));
    }
}

