/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.Ingredient;

public class MCIngredientList
implements IIngredient {
    private IIngredient[] ingredients;

    public MCIngredientList(IIngredient[] ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public boolean matches(IItemStack stack) {
        for (IIngredient item : this.ingredients) {
            if (!item.matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return Ingredient.merge((Collection)Arrays.stream(this.ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toList()));
    }

    @Override
    public String getCommandString() {
        return "";
    }

    @Override
    public IItemStack[] getItems() {
        ArrayList stacks = new ArrayList();
        Arrays.stream(this.ingredients).map(ing -> Arrays.asList(ing.getItems())).forEach(stacks::addAll);
        return stacks.toArray(new IItemStack[0]);
    }
}

