/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.impl.data.StringData;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.nbt.CompoundNBT;
import org.openzen.zencode.java.StorageTagType;
import org.openzen.zencode.java.ZenCodeStorageTag;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.MapData")
@ZenRegister
@Document(value="vanilla/api/data/MapData")
public class MapData
implements IData {
    private CompoundNBT internal;

    public MapData(CompoundNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public MapData() {
        this.internal = new CompoundNBT();
    }

    @ZenCodeType.Constructor
    public MapData(Map<@ZenCodeStorageTag(value=StorageTagType.STATIC) String, IData> map) {
        this.internal = new CompoundNBT();
        this.putAll(map);
    }

    @ZenCodeType.Method
    public void putAll(Map<String, IData> map) {
        map.forEach((s, iData) -> this.internal.func_218657_a(s, iData.getInternal()));
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public MapData opAdd(IData data) {
        this.putAll(data.asMap());
        return this;
    }

    @ZenCodeType.Getter(value="keySet")
    public Set<String> getKeySet() {
        return this.internal.func_150296_c();
    }

    @ZenCodeType.Getter(value="size")
    public int getSize() {
        return this.internal.func_186856_d();
    }

    @ZenCodeType.Method
    public IData put(String key, IData value) {
        return NBTConverter.convert(this.internal.func_218657_a(key, value.getInternal()));
    }

    @ZenCodeType.Method
    public IData get(String key) {
        return NBTConverter.convert(this.internal.func_74781_a(key));
    }

    @ZenCodeType.Method
    public boolean contains(String key) {
        return this.internal.func_74764_b(key);
    }

    @ZenCodeType.Method
    public void remove(String key) {
        this.internal.func_82580_o(key);
    }

    @ZenCodeType.Getter(value="isEmpty")
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @ZenCodeType.Method
    public MapData merge(MapData other) {
        return new MapData(this.internal.func_197643_a(other.getInternal()));
    }

    @Override
    public IData copy() {
        return new MapData(this.internal);
    }

    @Override
    public IData copyInternal() {
        return new MapData(this.getInternal().func_74737_b());
    }

    public CompoundNBT getInternal() {
        return this.internal;
    }

    @Override
    public Map<String, IData> asMap() {
        HashMap<String, IData> newMap = new HashMap<String, IData>();
        this.internal.func_150296_c().forEach(s -> newMap.put((String)s, this.get((String)s)));
        return newMap;
    }

    @Override
    public boolean contains(IData data) {
        if (data instanceof StringData) {
            return this.internal.func_74764_b(data.asString());
        }
        Map<String, IData> dataMap = data.asMap();
        if (dataMap == null) {
            return false;
        }
        for (Map.Entry<String, IData> dataEntry : dataMap.entrySet()) {
            if (!this.getInternal().func_74764_b(dataEntry.getKey())) {
                return false;
            }
            if (NBTConverter.convert(this.getInternal().func_74781_a(dataEntry.getKey())).contains(dataEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        boolean first = true;
        for (String key : this.internal.func_150296_c()) {
            IData value = this.get(key);
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            if (this.isValidIdentifier(key)) {
                result.append(key);
            } else {
                result.append("\"").append(key).append("\"");
            }
            result.append(": ");
            result.append(value.asString());
        }
        result.append('}');
        return result.toString();
    }

    private boolean isValidIdentifier(String str) {
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @ZenCodeType.Caster(implicit=true)
    public Map<String, IData> castToMap() {
        return this.asMap();
    }

    @Override
    public String toJsonString() {
        StringJoiner sj = new StringJoiner(",", "{", "}");
        this.asMap().forEach((s, iData) -> sj.add(String.format(Locale.ENGLISH, "\"%s\" : %s", s, iData.toJsonString())));
        return sj.toString();
    }
}

