/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.ICollectionData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ListData")
@ZenRegister
@Document(value="vanilla/api/data/ListData")
public class ListData
implements ICollectionData {
    private ListNBT internal;

    public ListData(ListNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ListData() {
        this.internal = new ListNBT();
    }

    @ZenCodeType.Constructor
    public ListData(@ZenCodeType.Optional List<IData> list) {
        this.internal = new ListNBT();
        if (list != null) {
            list.forEach(iData -> this.internal.add((Object)iData.getInternal()));
        }
    }

    @ZenCodeType.Constructor
    public ListData(IData ... array) {
        this(ListData.getArraySafe(array));
    }

    private static List<IData> getArraySafe(IData ... array) {
        if (array == null) {
            array = new IData[]{};
        }
        return Arrays.asList(array);
    }

    @Override
    public IData set(int index, IData value) {
        return NBTConverter.convert(this.internal.set(index, value.getInternal()));
    }

    @Override
    public void add(int index, IData value) {
        this.internal.add(index, value.getInternal());
    }

    @Override
    public void add(IData value) {
        this.internal.add((Object)value.getInternal());
    }

    @Override
    public IData remove(int index) {
        return NBTConverter.convert(this.internal.remove(index));
    }

    @Override
    public IData get(int index) {
        return NBTConverter.convert(this.internal.get(index));
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    @Override
    public IData copy() {
        return new ListData(this.internal);
    }

    @Override
    public IData copyInternal() {
        return new ListData(this.getInternal().func_74737_b());
    }

    public ListNBT getInternal() {
        return this.internal;
    }

    @Override
    public List<IData> asList() {
        ArrayList<IData> data = new ArrayList<IData>();
        for (INBT inbt : this.internal) {
            data.add(NBTConverter.convert(inbt));
        }
        return data;
    }

    @Override
    public boolean contains(IData data) {
        List<IData> dataValues = data.asList();
        if (dataValues != null && this.containsList(dataValues)) {
            return true;
        }
        for (INBT value : this.internal) {
            if (!NBTConverter.convert(value).contains(data)) continue;
            return true;
        }
        return false;
    }

    private boolean containsList(List<IData> dataValues) {
        block0: for (IData dataValue : dataValues) {
            for (INBT value : this.internal) {
                if (!NBTConverter.convert(value).contains(dataValue)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public String asString() {
        StringBuilder output = new StringBuilder();
        output.append('[');
        boolean first = true;
        for (INBT inbt : this.internal) {
            if (first) {
                first = false;
            } else {
                output.append(", ");
            }
            output.append(NBTConverter.convert(inbt).asString());
        }
        output.append(']');
        return output.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public List<IData> castToMap() {
        return this.asList();
    }
}

