/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.block.material.MCMaterial;
import com.blamejared.crafttweaker.impl.blocks.MCBlockState;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.entity.MCEntityClassification;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import com.blamejared.crafttweaker.impl.potion.MCEffect;
import com.blamejared.crafttweaker.impl.potion.MCPotion;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.util.MCDirectionAxis;
import com.blamejared.crafttweaker.impl.util.MCResourceLocation;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="blockmaterial")
    public static MCMaterial getBlockMaterial(String tokens) {
        try {
            for (Field field : Material.class.getFields()) {
                if (!field.getName().equalsIgnoreCase(tokens)) continue;
                return new MCMaterial((Material)field.get(null), field.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error gettig blockmaterial <blockmaterial:" + tokens + ">!", e);
        }
        try {
            CraftTweakerAPI.logInfo("Trying to get blockmaterial '%s' via ObfuscationHelper", tokens);
            Field field = ObfuscationReflectionHelper.findField(Material.class, (String)tokens.toUpperCase());
            return new MCMaterial((Material)field.get(null), tokens);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find blockmaterial <blockmaterial:" + tokens + ">!");
        }
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static MCBlockState getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("BlockState BEP <blockstate:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String properties;
            String blockName = split[0] + ":" + split[1];
            String string = properties = split.length > 2 ? split[2] : "";
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName))) {
                CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not appear to exist!"), new Object[0]);
            } else {
                return BracketHandlers.getBlockState(blockName, properties);
            }
        }
        CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"), new Object[0]);
        return null;
    }

    public static MCBlockState getBlockState(String name, String properties) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null) {
            return null;
        }
        MCBlockState blockState = new MCBlockState(block.func_176223_P());
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CraftTweakerAPI.logWarning("Invalid blockstate property format '" + propertyPair + "'. Using default property value.", new Object[0]);
                    continue;
                }
                blockState = blockState.withProperty(splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @ZenCodeType.Method
    @BracketResolver(value="directionaxis")
    public static MCDirectionAxis getDirectionAxis(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("DirectionAxis BEP <directionaxis:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 1) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Syntax is <directionaxis:axis>");
        }
        if (Direction.Axis.func_176717_a((String)split[0]) != null) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Axis does not appear to exist!");
        }
        return MCDirectionAxis.getAxis(Direction.Axis.func_176717_a((String)split[0]));
    }

    @BracketResolver(value="effect")
    @ZenCodeType.Method
    public static MCEffect getEffect(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Effect BEP <effect:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get effect with name: <effect:" + tokens + ">! Syntax is <effect:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTIONS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get effect with name: <potion:" + tokens + ">! Effect does not appear to exist!");
        }
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(key);
        return new MCEffect(effect);
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static MCEntityType getEntityType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            CraftTweakerAPI.logError("Could not get entitytype <entityType:%s>", tokens);
            return null;
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        if (!ForgeRegistries.ENTITIES.containsKey(resourceLocation)) {
            CraftTweakerAPI.logError("Could not get entitytype <entityType:%s>", tokens);
            return null;
        }
        return new MCEntityType((EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Item BEP <item:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ITEMS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!");
        }
        ItemStack value = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(key));
        return new MCItemStack(value);
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static MCPotion getPotion(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Potion BEP <potion:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Syntax is <potion:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTIONS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Potion does not appear to exist!");
        }
        Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(key);
        return new MCPotion(potion);
    }

    @ZenCodeType.Method
    public static IRecipeManager getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("RecipeType BEP <recipetype:%s> does not seem to be lower-cased!", tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        ResourceLocation key = new ResourceLocation(tokens);
        if (RecipeTypeBracketHandler.containsCustomManager(key)) {
            return RecipeTypeBracketHandler.getCustomManager(key);
        }
        Optional value = Registry.field_218367_H.func_218349_b(key);
        if (value.isPresent()) {
            return new RecipeManagerWrapper((IRecipeType)value.get());
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not appear to exist!");
    }

    @ZenCodeType.Method
    @BracketResolver(value="resource")
    public static MCResourceLocation getResourceLocation(String tokens) {
        return new MCResourceLocation(new ResourceLocation(tokens));
    }

    @ZenCodeType.Method
    @BracketResolver(value="entityclassification")
    public static MCEntityClassification getEntityClassification(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 1) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        if (Arrays.stream(EntityClassification.values()).anyMatch(entityClassification -> entityClassification.name().equalsIgnoreCase(tokens))) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        return new MCEntityClassification(EntityClassification.valueOf((String)tokens.toUpperCase()));
    }

    @ZenCodeType.Method
    @BracketResolver(value="tag")
    public static MCTag getTag(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Tag BEP <tag:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get Tag with name: <tag:" + tokens + ">! Syntax is <tag:modid:tagname>");
        }
        return new MCTag(new ResourceLocation(tokens));
    }
}

