/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.annotations.BracketDumper;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketDumpers")
public class BracketDumpers {
    @BracketDumper(value="item")
    public static Collection<String> getItemBracketDump() {
        HashSet<String> result = new HashSet<String>();
        for (ResourceLocation key : ForgeRegistries.ITEMS.getKeys()) {
            result.add(String.format(Locale.ENGLISH, "<item:%s>", key));
        }
        return result;
    }

    @BracketDumper(value="recipetype")
    public static Collection<String> getRecipeTypeDump() {
        HashSet<String> result = new HashSet<String>();
        Registry.field_218367_H.func_148742_b().stream().filter(rl -> !rl.toString().equals("crafttweaker:scripts")).forEach(rl -> result.add(String.format(Locale.ENGLISH, "<recipetype:%s>", rl)));
        return result;
    }

    @BracketDumper(value="entitytype")
    public static Collection<String> getEntityTypeDump() {
        return ForgeRegistries.ENTITIES.getKeys().stream().map(key -> "<entitytype:" + key + ">").collect(Collectors.toList());
    }

    @BracketDumper(value="entityclassification")
    public static Collection<String> getEntityClassificationDump() {
        return Arrays.stream(EntityClassification.values()).map(key -> "<entityclassification:" + key.name().toLowerCase() + ">").collect(Collectors.toList());
    }

    @BracketDumper(value="directionaxis")
    public static Collection<String> getDirectionAxisDump() {
        return Arrays.stream(Direction.Axis.values()).map(key -> "<directionaxis:" + key + ">").collect(Collectors.toList());
    }
}

