/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ActionRemoveRecipeByOutputInput
extends ActionRecipeBase {
    private final IItemStack output;
    private final IIngredient input;

    public ActionRemoveRecipeByOutputInput(IRecipeManager manager, IItemStack output, IIngredient input) {
        super(manager);
        this.output = output;
        this.input = input;
    }

    @Override
    public void apply() {
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        block0: for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
            IRecipe<?> recipe = this.getManager().getRecipes().get(location);
            ItemStack recOut = recipe.func_77571_b();
            if (!this.output.matches(new MCItemStackMutable(recOut))) continue;
            for (IItemStack item : this.input.getItems()) {
                if (!((Ingredient)recipe.func_192400_c().get(0)).test(item.getInternal())) continue;
                toRemove.add(location);
                continue block0;
            }
        }
        toRemove.forEach(this.getManager().getRecipes()::remove);
    }

    @Override
    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + this.output + "\"";
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.output == null) {
            logger.throwingWarn("output cannot be null!", new ScriptException("output IItemStack cannot be null!"));
            return false;
        }
        return true;
    }
}

