/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ActionRemoveRecipeByOutput
extends ActionRecipeBase {
    private final IItemStack output;

    public ActionRemoveRecipeByOutput(IRecipeManager manager, IItemStack output) {
        super(manager);
        this.output = output;
    }

    @Override
    public void apply() {
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
            ItemStack recOut = this.getManager().getRecipes().get(location).func_77571_b();
            if (!this.output.matches(new MCItemStackMutable(recOut))) continue;
            toRemove.add(location);
        }
        toRemove.forEach(this.getManager().getRecipes()::remove);
    }

    @Override
    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + this.output + "\"";
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.output == null) {
            logger.throwingWarn("output cannot be null!", new ScriptException("output IItemStack cannot be null!"));
            return false;
        }
        return true;
    }
}

