/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketDumper;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.BracketValidator;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.brackets.ValidatedEscapableBracketParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.openzen.zencode.java.JavaNativeModule;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;

public class CraftTweakerRegistry {
    private static final Type TYPE_ZEN_REGISTER = Type.getType(ZenRegister.class);
    private static final Type TYPE_PRE_PROCESSOR = Type.getType(Preprocessor.class);
    private static final List<Class> ZEN_CLASSES = new ArrayList<Class>();
    private static final List<Class> ZEN_GLOBALS = new ArrayList<Class>();
    private static final Map<String, Method> BRACKET_RESOLVERS = new HashMap<String, Method>();
    private static final Map<String, Collection<String>> BRACKET_RESOLVERS_2 = new HashMap<String, Collection<String>>();
    private static final Map<String, Method> BRACKET_VALIDATORS = new HashMap<String, Method>();
    private static final Map<String, Supplier<Collection<String>>> BRACKET_DUMPERS = new HashMap<String, Supplier<Collection<String>>>();
    private static final Map<String, Class> ZEN_CLASS_MAP = new HashMap<String, Class>();
    private static final List<IPreprocessor> PREPROCESSORS = new ArrayList<IPreprocessor>();
    private static final Map<String, List<Class>> EXPANSIONS = new HashMap<String, List<Class>>();
    private static final List<Class<? extends IRecipeManager>> RECIPE_MANAGERS = new ArrayList<Class<? extends IRecipeManager>>();

    public static void findClasses() {
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TYPE_ZEN_REGISTER.equals((Object)a.getAnnotationType())).collect(Collectors.toList()).forEach(CraftTweakerRegistry::addClass);
        CraftTweakerRegistry.sortClasses();
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TYPE_PRE_PROCESSOR.equals((Object)a.getAnnotationType())).forEach(data -> {
            Type type = data.getClassType();
            try {
                Class<?> clazz = Class.forName(type.getClassName(), false, CraftTweaker.class.getClassLoader());
                boolean valid = false;
                for (Class<?> intFace : clazz.getInterfaces()) {
                    if (intFace != IPreprocessor.class) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    CraftTweakerAPI.logWarning("Preprocessor: \"%s\" does not implement IPreprocessor!", type.getClassName());
                    return;
                }
                IPreprocessor preprocessor = null;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterCount() != 0) continue;
                    try {
                        preprocessor = (IPreprocessor)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        CraftTweakerAPI.logThrowing("Preprocessor: \"%s\" can not be instantiated! Make sure it has a public empty constructor", e, new Object[0]);
                        e.printStackTrace();
                    }
                }
                if (preprocessor != null) {
                    PREPROCESSORS.add(preprocessor);
                } else {
                    CraftTweakerAPI.logWarning("Can not register Preprocessor: \"%s\"!", type.getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        CraftTweakerRegistry.validateBrackets();
    }

    private static void addClass(ModFileScanData.AnnotationData data) {
        if (data.getAnnotationData().containsKey("modDeps")) {
            List modOnly = (List)data.getAnnotationData().get("modDeps");
            for (String mod : modOnly) {
                if (mod == null || mod.isEmpty() || ModList.get().isLoaded(mod)) continue;
                return;
            }
        }
        CraftTweaker.LOG.info("Found ZenRegister: {}", (Object)data.getClassType().getClassName());
        try {
            Class<?> clazz = Class.forName(data.getClassType().getClassName(), false, CraftTweaker.class.getClassLoader());
            ZEN_CLASSES.add(clazz);
            if (!clazz.isInterface() && IRecipeManager.class.isAssignableFrom(clazz)) {
                RECIPE_MANAGERS.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void sortClasses() {
        for (Class zenClass : ZEN_CLASSES) {
            if (zenClass.isAnnotationPresent(ZenCodeType.Name.class)) {
                ZenCodeType.Name name = zenClass.getAnnotation(ZenCodeType.Name.class);
                ZEN_CLASS_MAP.put(name.value(), zenClass);
            }
            if (zenClass.isAnnotationPresent(ZenCodeType.Expansion.class)) {
                EXPANSIONS.computeIfAbsent(zenClass.getAnnotation(ZenCodeType.Expansion.class).value(), s -> new ArrayList()).add(zenClass);
            }
            if (CraftTweakerRegistry.hasGlobal(zenClass)) {
                ZEN_GLOBALS.add(zenClass);
            }
            for (Method method : zenClass.getDeclaredMethods()) {
                CraftTweakerRegistry.handleBracketResolver(method);
                CraftTweakerRegistry.handleBracketDumper(method);
                CraftTweakerRegistry.handleBracketValidator(method);
            }
        }
    }

    private static void handleBracketValidator(Method method) {
        if (!method.isAnnotationPresent(BracketValidator.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketValidator, but it is not public and static.", method.toString());
            return;
        }
        boolean valid = true;
        String value = method.getAnnotation(BracketValidator.class).value();
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1 && parameters[0].equals(String.class)) {
            if (BRACKET_VALIDATORS.containsKey(value)) {
                CraftTweakerAPI.logError("Bracket validator for bep name %s was found twice: %s and %s", value, BRACKET_VALIDATORS.get(value), method);
                valid = false;
            }
        } else {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketValidator, but it does not have a String as it's only parameter.", method.toString());
            valid = false;
        }
        if (method.getReturnType() != Boolean.TYPE) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketValidator, so it must return a boolean", method);
            valid = false;
        }
        if (valid) {
            BRACKET_VALIDATORS.put(value, method);
        }
    }

    private static void handleBracketResolver(Method method) {
        if (!method.isAnnotationPresent(BracketResolver.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketResolver, but it is not public and static.", method.toString());
            return;
        }
        boolean isValid = true;
        Class<?>[] parameters = method.getParameterTypes();
        String name = method.getAnnotation(BracketResolver.class).value();
        if (parameters.length != 1 || !parameters[0].equals(String.class)) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketResolver, but it does not have a String as it's only parameter.", method.toString());
            isValid = false;
        }
        if (!CommandStringDisplayable.class.isAssignableFrom(method.getReturnType())) {
            CraftTweakerAPI.logError("Method \"%s\" is marked as a BracketResolver, so it should return something that implements %s.", method.toString(), CommandStringDisplayable.class.getSimpleName());
            isValid = false;
        }
        if (!BRACKET_RESOLVERS.getOrDefault(name, method).equals(method)) {
            Method other = BRACKET_RESOLVERS.get(name);
            CraftTweakerAPI.logError("BracketResolve \"%s\" was registered twice: '%s' and '%s'", name, other, method);
            isValid = false;
        }
        if (isValid) {
            BRACKET_RESOLVERS.put(name, method);
            Class<?> cls = method.getDeclaringClass();
            String clsName = cls.isAnnotationPresent(ZenCodeType.Name.class) ? cls.getAnnotation(ZenCodeType.Name.class).value() : cls.getCanonicalName();
            BRACKET_RESOLVERS_2.computeIfAbsent(clsName.split("[.]", 2)[0], s -> new ArrayList()).add(name);
        }
    }

    private static void handleBracketDumper(Method method) {
        if (!method.isAnnotationPresent(BracketDumper.class)) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as a BracketDumper, but it is not public and static.", method.toString());
            return;
        }
        if (method.getParameterCount() != 0) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 0 parameters.", method.toString());
            return;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType()) || ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0] != String.class) {
            CraftTweakerAPI.logWarning("Method \"%s\" is marked as BracketDumper but does not have 'Collection<String>' as return type.", method.toGenericString());
            return;
        }
        String value = method.getAnnotation(BracketDumper.class).value();
        BRACKET_DUMPERS.merge(value, () -> {
            try {
                return (Collection)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                return null;
            }
        }, (dumpFun1, dumpFun2) -> () -> CraftTweakerRegistry.lambda$null$6((Supplier)dumpFun1, (Supplier)dumpFun2));
    }

    private static boolean hasGlobal(Class zenClass) {
        for (Method method : zenClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : zenClass.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !Modifier.isPublic(((Field)accessibleObject).getModifiers()) || !Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Class> getZenClassMap() {
        return ImmutableMap.copyOf(ZEN_CLASS_MAP);
    }

    public static List<Class> getClassesInPackage(String name) {
        return ZEN_CLASS_MAP.keySet().stream().filter(key -> key.startsWith(name)).map(ZEN_CLASS_MAP::get).collect(Collectors.toList());
    }

    public static Set<String> getRootPackages() {
        return ZEN_CLASS_MAP.keySet().stream().map(s -> s.split("\\.")[0]).collect(Collectors.toSet());
    }

    public static List<Class> getZenGlobals() {
        return ImmutableList.copyOf(ZEN_GLOBALS);
    }

    public static List<ValidatedEscapableBracketParser> getBracketResolvers(String name, ScriptingEngine scriptingEngine, JavaNativeModule crafttweakerModule) {
        ArrayList<ValidatedEscapableBracketParser> validatedEscapableBracketParsers = new ArrayList<ValidatedEscapableBracketParser>();
        for (String bepName : (Collection)BRACKET_RESOLVERS_2.getOrDefault(name, Collections.emptyList())) {
            Method parserMethod = BRACKET_RESOLVERS.get(bepName);
            Method validatorMethod = CraftTweakerRegistry.getBracketValidator(bepName);
            FunctionalMemberRef functionalMemberRef = crafttweakerModule.loadStaticMethod(parserMethod);
            ValidatedEscapableBracketParser validated = new ValidatedEscapableBracketParser(bepName, functionalMemberRef, validatorMethod, scriptingEngine.registry);
            validatedEscapableBracketParsers.add(validated);
        }
        return validatedEscapableBracketParsers;
    }

    public static Method getBracketValidator(String bepName) {
        return BRACKET_VALIDATORS.getOrDefault(bepName, null);
    }

    private static void validateBrackets() {
        for (String validatedBep : BRACKET_VALIDATORS.keySet()) {
            if (BRACKET_RESOLVERS.containsKey(validatedBep)) continue;
            CraftTweakerAPI.logError("BEP %s has a validator but no BEP method", validatedBep);
        }
    }

    public static Map<String, Supplier<Collection<String>>> getBracketDumpers() {
        return ImmutableMap.copyOf(BRACKET_DUMPERS);
    }

    public static List<Class<? extends IRecipeManager>> getRecipeManagers() {
        return ImmutableList.copyOf(RECIPE_MANAGERS);
    }

    public static List<IPreprocessor> getPreprocessors() {
        return PREPROCESSORS;
    }

    public static Map<String, List<Class>> getExpansions() {
        return EXPANSIONS;
    }

    private static /* synthetic */ Collection lambda$null$6(Supplier dumpFun1, Supplier dumpFun2) {
        Collection strings1 = (Collection)dumpFun1.get();
        Collection strings2 = (Collection)dumpFun2.get();
        HashSet result = new HashSet(strings1.size() + strings2.size());
        result.addAll(strings1);
        result.addAll(strings2);
        return result;
    }
}

