/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import com.mojang.authlib.exceptions.AuthenticationException;
import java.awt.Color;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.gui.PasswordFieldWidget;

public final class ScreenAuth
extends Screen {
    private TextFieldWidget username;
    private PasswordFieldWidget pw;
    private Button confirm;
    private Button cancel;
    private CheckboxButton save;
    private Button config;
    private Screen prev;
    private int baseY;
    private String message = "";

    public ScreenAuth(Screen prev) {
        super((ITextComponent)new TranslationTextComponent("reauth.gui.auth.title", new Object[0]));
        this.prev = prev;
    }

    public void init() {
        String msg;
        super.init();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.baseY = this.height / 2 - 55;
        this.username = new TextFieldWidget(this.font, this.width / 2 - 155, this.baseY + 15, 310, 20, I18n.func_135052_a((String)"reauth.gui.auth.username", (Object[])new Object[0]));
        this.username.func_146203_f(512);
        this.username.func_146180_a(ReAuth.config.getUsername());
        this.addButton((Widget)this.username);
        this.pw = new PasswordFieldWidget(this.font, this.width / 2 - 155, this.baseY + 60, 310, 20, I18n.func_135052_a((String)"reauth.gui.auth.password", (Object[])new Object[0]));
        this.pw.func_146203_f(Short.MAX_VALUE);
        this.pw.func_146180_a(ReAuth.config.getPassword());
        this.addButton((Widget)this.pw);
        this.focus((TextFieldWidget)(this.username.func_146179_b().isEmpty() ? this.username : this.pw));
        this.save = new CheckboxButton(this.width / 2 - 155, this.baseY + 85, 310, 20, I18n.func_135052_a((String)"reauth.gui.auth.checkbox", (Object[])new Object[0]), !this.pw.func_146179_b().isEmpty());
        if (ReAuth.config.hasCrypto()) {
            this.addButton((Widget)this.save);
        }
        this.confirm = new Button(this.width / 2 - 155, this.baseY + 110, 153, 20, "", b -> this.doLogin());
        this.addButton((Widget)this.confirm);
        this.cancel = new Button(this.width / 2 + 2, this.baseY + 110, 155, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), b -> this.getMinecraft().func_147108_a(this.prev));
        this.addButton((Widget)this.cancel);
        this.config = new Button(this.width - 80, this.height - 25, 75, 20, I18n.func_135052_a((String)"reauth.gui.auth.config", (Object[])new Object[0]), b -> {
            ReAuth.config.setCredentials("", "", "");
            this.onClose();
        });
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ReAuth.modInfo);
        if ((result.status == VersionChecker.Status.OUTDATED || result.status == VersionChecker.Status.BETA_OUTDATED) && (msg = (String)result.changes.get(result.target)) != null) {
            this.message = I18n.func_135052_a((String)"reauth.gui.auth.update", (Object[])new Object[]{msg});
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"reauth.gui.auth.text1", (Object[])new Object[0]), this.width / 2, this.baseY, Color.WHITE.getRGB());
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"reauth.gui.auth.text2", (Object[])new Object[0]), this.width / 2, this.baseY + 45, Color.WHITE.getRGB());
        if (!this.message.isEmpty()) {
            this.drawCenteredString(this.font, this.message, this.width / 2, this.baseY - 15, 0xFFFFFF);
        }
        if (!ReAuth.config.hasCrypto()) {
            this.drawString(this.font, I18n.func_135052_a((String)"reauth.gui.auth.noCrypto", (Object[])new Object[0]), this.width / 2 - 155, this.baseY + 90, Color.WHITE.getRGB());
        }
        LoginType status = this.getLoginType();
        this.confirm.setMessage(I18n.func_135052_a((String)status.getTranslation(), (Object[])new Object[0]));
        this.confirm.active = status.isActive();
        super.render(mouseX, mouseY, partialTicks);
    }

    private void focus(TextFieldWidget widget) {
        IGuiEventListener old = this.getFocused();
        if (old instanceof TextFieldWidget) {
            ((TextFieldWidget)old).func_146195_b(false);
        }
        if (widget != null) {
            widget.func_146195_b(true);
        }
        this.func_212928_a((IGuiEventListener)widget);
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 257 || keyCode == 335) {
            IGuiEventListener focus = this.getFocused();
            if (focus == this.username) {
                this.focus(this.pw);
                return true;
            }
            if (focus == this.pw) {
                this.doLogin();
                return true;
            }
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    private LoginType getLoginType() {
        String user = this.username.func_146179_b();
        if (user.isEmpty()) {
            return LoginType.None;
        }
        if (this.pw.func_146179_b().isEmpty()) {
            if (ReAuth.auth.isValidName(user)) {
                return LoginType.Offline;
            }
            return LoginType.None;
        }
        return LoginType.Online;
    }

    private void doLogin() {
        boolean success = false;
        try {
            LoginType type = this.getLoginType();
            switch (type) {
                case Online: {
                    ReAuth.auth.login(this.username.func_146179_b(), this.pw.getPW(), this.save.func_212942_a());
                    break;
                }
                case Offline: {
                    ReAuth.auth.offline(this.username.func_146179_b());
                    break;
                }
                default: {
                    return;
                }
            }
            this.message = I18n.func_135052_a((String)"reauth.login.success", (Object[])new Object[0]);
            success = true;
        }
        catch (AuthenticationException e) {
            this.message = I18n.func_135052_a((String)"reauth.login.fail", (Object[])new Object[]{e.getMessage()});
            ReAuth.log.error("Login failed:", (Throwable)e);
        }
        catch (Exception e) {
            this.message = I18n.func_135052_a((String)"reauth.login.error", (Object[])new Object[]{e.getMessage()});
            ReAuth.log.error("Error:", (Throwable)e);
        }
        if (success) {
            this.onClose();
        }
    }

    public void onClose() {
        this.getMinecraft().func_147108_a(this.prev);
    }

    public void removed() {
        super.removed();
        this.pw.setPassword(new char[0]);
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    private static enum LoginType {
        None(false, "none"),
        Online(true, "online"),
        Offline(true, "offline");

        private final boolean active;
        private final String translation;

        private LoginType(boolean active, String translation) {
            this.active = active;
            this.translation = translation;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getTranslation() {
            return "reauth.gui.auth.confirm." + this.translation;
        }
    }
}

