/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public class PerkJailer
extends Perk {
    public PerkJailer() {
        super("jailer", new ResourceLocation("tombstone", "textures/item/grave_key.png"));
    }

    @Override
    public int getLevelMax() {
        return 5 - (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable PlayerEntity player) {
        return (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == -1 || (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() == 100;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 20 + "%% " + I18n.func_135052_a((String)("tombstone.perk." + this.name + ".desc"), (Object[])new Object[0]);
        }
        if (level == actualLevel + 1) {
            return "+" + level * 20 + "%%";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public int getLevelBonus(PlayerEntity player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getClientTranslationWithStyle(StyleType.MESSAGE_SPECIAL, (Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get() + levelWithBonus * 20);
    }
}

