/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleCasting
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/casting.png");
    private final LivingEntity caster;
    private final Predicate<LivingEntity> predic;
    private final double radius = 1.1;
    private double angle;
    private static final float rotIncrement = 0.15707964f;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(World world, LivingEntity caster, Predicate<LivingEntity> predic, double addY, double angle) {
        super(world, caster.func_226277_ct_(), caster.func_226278_cu_() + addY, caster.func_226281_cx_());
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.func_82338_g(1.0f);
        this.goUp = addY < 1.0;
        this.caster = caster;
        this.predic = predic;
        this.field_70544_f = world.field_73012_v.nextFloat() * 0.1f + 0.15f;
        this.angle = angle + Helper.getRandom(-0.25, 0.25);
        this.field_190014_F = world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
        float[] color = Helper.getRGBColor3F((Integer)ConfigTombstone.client.particleCastingColor.get());
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.field_190017_n = false;
        this.updatePosition();
    }

    private void updatePosition() {
        this.angle += (double)0.01f;
        this.field_187123_c = this.field_187126_f = this.caster.func_226277_ct_() + this.radius * Math.cos(Math.PI * 2 * this.angle);
        this.field_187124_d = this.field_187127_g += this.goUp ? 0.02 : -0.02;
        this.field_187125_e = this.field_187128_h = this.caster.func_226281_cx_() + this.radius * Math.sin(Math.PI * 2 * this.angle);
        this.func_70538_b(this.clampColor(this.colorR + Helper.getRandom(-20.0f, 20.0f) / 255.0f), this.clampColor(this.colorG - Helper.getRandom(-20.0f, 20.0f) / 255.0f), this.clampColor(this.colorB + Helper.getRandom(-20.0f, 20.0f) / 255.0f));
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += 0.15707964f;
    }

    private float clampColor(float color) {
        return MathHelper.func_76131_a((float)color, (float)0.0f, (float)1.0f);
    }

    public void func_189213_a() {
        if (this.field_187127_g > this.caster.func_226278_cu_() + 2.0 || this.field_187127_g < this.caster.func_226278_cu_()) {
            boolean bl = this.goUp = !this.goUp;
        }
        if (this.predic.test(this.caster)) {
            this.func_187112_i();
        }
        this.updatePosition();
        ++this.field_70546_d;
    }

    protected int func_189214_a(float partialTick) {
        int skylight = 5;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

