/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SmokeColumnMessage;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemDustOfVanishing
extends ItemGeneric {
    public ItemDustOfVanishing() {
        super("dust_of_vanishing", ItemDustOfVanishing.getBuilder(true), () -> SharedConfigTombstone.allowed_magic_items.allowDustOfVanishing.get());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_150255_a(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == this && !EntityHelper.hasCooldown(player, this)) {
            Vec3d pVec = player.func_174791_d();
            if (!world.field_72995_K) {
                world.func_184148_a(null, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.5f);
                Location spawnPos = this.findBackwardLocation((ServerWorld)world, player, 8.0);
                if (!spawnPos.isOrigin()) {
                    Helper.teleportEntity(player, spawnPos);
                } else {
                    spawnPos = this.findBackwardLocation((ServerWorld)world, player, 3.0);
                    if (!spawnPos.isOrigin()) {
                        Helper.teleportEntity(player, spawnPos);
                    }
                }
                player.field_70143_R = 0.0f;
                stack.func_190918_g(1);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 100);
                EntityHelper.setCooldown(player, this, 200);
                PacketHandler.sendToAllTrackingPlayers(new SmokeColumnMessage(player.func_145782_y()), (LivingEntity)player);
            }
            ModTombstone.PROXY.produceSmokeColumn(world, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return false;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j() != null) {
            this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
        }
        return ActionResultType.SUCCESS;
    }

    private Location findBackwardLocation(ServerWorld world, PlayerEntity player, double range) {
        return new SpawnHelper(world, new BlockPos(player.func_174791_d().func_178786_a(player.func_70040_Z().field_72450_a * range, 0.0, player.func_70040_Z().field_72449_c * range))).findSafePlace(2, true);
    }
}

