/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.FunctionObject;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class WorldFunctionInjector {
    private final ImmutableMap<ResourceLocation, CommandFunction> functions;

    private WorldFunctionInjector(ImmutableMap<ResourceLocation, CommandFunction> functions) {
        this.functions = functions;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        FunctionManager manager;
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && (manager = ((ServerWorld)world).func_73046_m().func_193030_aL()) != null) {
            WorldFunctionInjector.inject(manager, this.functions);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void inject(FunctionManager manager, ImmutableMap<ResourceLocation, CommandFunction> functions) {
        Map delegate = manager.func_193066_d();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : functions.entrySet()) {
            if (delegate.containsKey(entry.getKey())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        ImmutableMap uniqueFunctions = builder.build();
        if (!uniqueFunctions.isEmpty()) {
            manager.field_193070_d = new InjectionMap(delegate, uniqueFunctions, Maps.newHashMap());
        }
    }

    public static final class ParameterMap {
        private final ImmutableMap<String, Object> parameters;

        private ParameterMap(ImmutableMap<String, Object> parameters) {
            this.parameters = parameters;
        }

        public boolean hasBoolean(String name) {
            return this.get(name) instanceof Boolean;
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Object value = this.get(name);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return defaultValue;
        }

        public boolean hasInt(String name) {
            return this.get(name) instanceof Number;
        }

        public int getInt(String name, int defaultValue) {
            Object value = this.get(name);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return defaultValue;
        }

        public boolean hasDouble(String name) {
            return this.get(name) instanceof Number;
        }

        public double getDouble(String name, double defaultValue) {
            Object value = this.get(name);
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return defaultValue;
        }

        public boolean hasString(String name) {
            return !Objects.toString(this.get(name), "").isEmpty();
        }

        public String getString(String name, String defaultValue) {
            String str = Objects.toString(this.get(name), "");
            if (str.isEmpty()) {
                return defaultValue;
            }
            return str;
        }

        private Object get(String name) {
            return this.parameters.get((Object)name);
        }
    }

    @FunctionalInterface
    public static interface CommandFunction {
        public void accept(CommandSource var1, ParameterMap var2);
    }

    public static final class Builder {
        private ImmutableMap.Builder<ResourceLocation, CommandFunction> functions;

        private Builder() {
            this((ImmutableMap.Builder<ResourceLocation, CommandFunction>)ImmutableMap.builder());
        }

        private Builder(ImmutableMap.Builder<ResourceLocation, CommandFunction> functions) {
            this.functions = functions;
        }

        public Builder put(ResourceLocation name, CommandFunction function) {
            this.functions.put((Object)name, (Object)function);
            return this;
        }

        public WorldFunctionInjector build() {
            return new WorldFunctionInjector(this.functions.build());
        }
    }

    private static final class InjectionMap
    extends ForwardingMap<ResourceLocation, FunctionObject> {
        private static final String PARAMETER_DELIMITER = "//";
        private static final Pattern PARAMETER = Pattern.compile("//([a-z_][a-z0-9_]*)/([a-z0-9._-]*)");
        private final Map<ResourceLocation, FunctionObject> delegate;
        private final ImmutableMap<ResourceLocation, CommandFunction> functions;
        private final Map<ResourceLocation, FunctionObject> objects;

        private InjectionMap(Map<ResourceLocation, FunctionObject> delegate, ImmutableMap<ResourceLocation, CommandFunction> functions, Map<ResourceLocation, FunctionObject> objects) {
            this.delegate = delegate;
            this.functions = functions;
            this.objects = objects;
        }

        protected Map<ResourceLocation, FunctionObject> delegate() {
            return this.delegate;
        }

        @Nullable
        public FunctionObject get(@Nullable Object key) {
            FunctionObject value = (FunctionObject)super.get(key);
            if (value == null && !super.containsKey(key) && key instanceof ResourceLocation) {
                return this.objects.computeIfAbsent((ResourceLocation)key, this::compute);
            }
            return value;
        }

        @Nullable
        private FunctionObject compute(ResourceLocation descriptor) {
            String parametersPart;
            String namePart;
            String path = descriptor.func_110623_a();
            int paramStart = path.indexOf(PARAMETER_DELIMITER);
            if (paramStart >= 0) {
                namePart = path.substring(0, paramStart);
                parametersPart = path.substring(paramStart);
            } else {
                namePart = path;
                parametersPart = "";
            }
            CommandFunction function = (CommandFunction)this.functions.get((Object)new ResourceLocation(descriptor.func_110624_b(), namePart));
            if (function != null) {
                ImmutableMap.Builder parameters = ImmutableMap.builder();
                Matcher m = PARAMETER.matcher(parametersPart).useTransparentBounds(true);
                while (m.lookingAt()) {
                    parameters.put((Object)m.group(1), this.parse(m.group(2)));
                    m.region(m.end(), m.regionEnd());
                }
                if (m.regionStart() == m.regionEnd()) {
                    ParameterMap map = new ParameterMap(parameters.build());
                    return new FunctionObject(new ResourceLocation("tombstone", "custom_function"), new FunctionObject.IEntry[]{(manager, sender, queue, maxChainLength) -> function.accept(sender, map)});
                }
            }
            return null;
        }

        private Object parse(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException2) {
                    if ("true".equals(value)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equals(value)) {
                        return Boolean.FALSE;
                    }
                    return value;
                }
            }
        }
    }
}

