/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.world.World;

public class TimeHelper {
    public static long systemTime() {
        return System.currentTimeMillis();
    }

    public static long systemTicks() {
        return System.currentTimeMillis() / 50L;
    }

    public static boolean isSystemTimeElapsed(long oldTime, long millis) {
        return TimeHelper.systemTime() - oldTime >= millis;
    }

    public static long worldTicks(World world) {
        return world.func_82737_E();
    }

    public static int tickFromSecond(int second) {
        return second * 20;
    }

    public static int tickFromMinute(int minute) {
        return minute * 1200;
    }

    public static int tickFromHour(int hour) {
        return hour * 72000;
    }

    public static int tickFromDay(int day) {
        return day * 1728000;
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval == 0L);
    }

    public static boolean inIntervalBefore(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval > (long)intervalStart);
    }

    public static boolean inIntervalAfter(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval < (long)intervalStart);
    }

    public static boolean testInterval(long ticksExisted, int tick, Predicate<Long> intervalPredic) {
        return ticksExisted > 0L && intervalPredic.test(ticksExisted % (long)tick);
    }

    public static long minuteElapsed(World world, long oldTime) {
        return TimeHelper.minuteElapsed(TimeHelper.worldTicks(world), oldTime);
    }

    public static long minuteElapsed(long nowTime, long oldTime) {
        return (nowTime - oldTime) / 1200L;
    }

    public static boolean isMinuteElapsed(World world, long oldTime, int minute) {
        return TimeHelper.isMinuteElapsed(TimeHelper.worldTicks(world), oldTime, minute);
    }

    public static boolean isMinuteElapsed(long nowTime, long oldTime, int minute) {
        return nowTime - oldTime >= (long)TimeHelper.tickFromMinute(minute);
    }

    public static String getTimeString(int cd) {
        int[] timeArray = TimeHelper.getTimeArray(cd);
        StringBuilder builder = new StringBuilder();
        IntStream.range(0, timeArray.length).filter(i -> timeArray[i] > 0).findFirst().ifPresent(first -> {
            builder.append(String.format("%02d", timeArray[first]));
            IntStream.range(first + 1, timeArray.length).forEach(unit -> builder.append(":").append(String.format("%02d", timeArray[unit])));
        });
        return builder.toString();
    }

    public static int[] getTimeArray(int cd) {
        int[] timeArray = new int[3];
        timeArray[0] = cd / 72000;
        if (timeArray[0] > 0) {
            cd -= timeArray[0] * 72000;
        }
        timeArray[1] = cd / 1200;
        if (timeArray[1] > 0) {
            cd -= timeArray[1] * 1200;
        }
        timeArray[2] = cd / 20;
        return timeArray;
    }
}

