/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.FakePlayer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;

public class EntityHelper {
    public static boolean hasEnchantment(LivingEntity entity, Enchantment ench) {
        return EntityHelper.hasEnchantment(entity, ench, 1);
    }

    public static boolean hasEnchantment(LivingEntity entity, Enchantment ench, int lvl) {
        for (ItemStack stack : ench.func_222181_a(entity).values()) {
            if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) < lvl) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(LivingEntity entity, Enchantment ench) {
        int lvl = 0;
        for (ItemStack stack : ench.func_222181_a(entity).values()) {
            int currentLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack);
            if (currentLvl <= lvl) continue;
            lvl = currentLvl;
        }
        return lvl;
    }

    public static boolean isValidPlayer(@Nullable ICommandSource sender) {
        return sender instanceof PlayerEntity && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isValidPlayerMP(@Nullable PlayerEntity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isValidPlayer(@Nullable PlayerEntity player) {
        return player != null && !(player instanceof FakePlayer);
    }

    public static boolean isSurvivalPlayer(@Nullable PlayerEntity player) {
        return EntityHelper.isValidPlayer(player) && !player.func_184812_l_() && !player.func_175149_v();
    }

    public static void setPlayerXp(PlayerEntity player, int amount) {
        if (amount < 0) {
            return;
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static int getPlayerTotalXp(PlayerEntity player) {
        return EntityHelper.getPlayerTotalXp(player.field_71068_ca, player.field_71106_cc);
    }

    public static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal;
        if (level < 17) {
            experienceTotal = level * level + 6 * level;
            experienceTotal = (int)((float)experienceTotal + (float)(2 * level + 7) * bar);
        } else if (level < 32) {
            experienceTotal = (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
            experienceTotal = (int)((float)experienceTotal + (float)(5 * level - 38) * bar);
        } else {
            experienceTotal = (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
            experienceTotal = (int)((float)experienceTotal + (float)(9 * level - 158) * bar);
        }
        return experienceTotal;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static boolean hasCooldown(@Nullable PlayerEntity player, Item item) {
        return EntityHelper.getCooldown(player, item) != 0.0f;
    }

    public static boolean hasCooldown(@Nullable PlayerEntity player, ItemStack stack) {
        return EntityHelper.hasCooldown(player, stack.func_77973_b());
    }

    public static void setCooldown(PlayerEntity player, Item item, int ticks) {
        player.func_184811_cZ().func_185145_a(item, ticks);
    }

    public static void setCooldown(PlayerEntity player, ItemStack stack, int ticks) {
        EntityHelper.setCooldown(player, stack.func_77973_b(), ticks);
    }

    public static float getCooldown(@Nullable PlayerEntity player, Item item) {
        return player != null ? player.func_184811_cZ().func_185143_a(item, 0.0f) : 0.0f;
    }

    public static long getKnowledge(PlayerEntity player) {
        return (Long)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(ITBCapability::getKnowledge).orElse((Object)0L);
    }

    public static void addKnowledge(ServerPlayerEntity player, long points) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> cap.addKnowledgeAndSync(player, points));
    }

    public static void removeKnowledge(ServerPlayerEntity player, long points) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> cap.removeKnowledgeAndSync(player, points));
    }

    public static void addAlignment(ServerPlayerEntity player, int amount, float chance) {
        if (Helper.random.nextFloat() < chance) {
            EntityHelper.addAlignment(player, amount);
        }
    }

    public static void addAlignment(ServerPlayerEntity player, int amount) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> cap.addAlignmentAndSync(player, amount));
    }

    public static boolean isBadAlignment(ServerPlayerEntity player) {
        return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getAlignmentLevel() < 0).orElse((Object)false);
    }

    public static int getPerkLevelWithBonus(@Nullable PlayerEntity player, @Nullable Perk perk) {
        return player == null ? 0 : (Integer)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> cap.getPerkLevelWithBonus(player, perk)).orElse((Object)0);
    }

    public static void syncTBCapability(ServerPlayerEntity player) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> cap.syncAll(player));
    }

    public static CompoundNBT getPersistentTag(PlayerEntity player) {
        CompoundNBT persistantData = player.getPersistentData();
        if (persistantData.func_150297_b("PlayerPersisted", 10)) {
            return persistantData.func_74775_l("PlayerPersisted");
        }
        CompoundNBT persistantTag = new CompoundNBT();
        persistantData.func_218657_a("PlayerPersisted", (INBT)persistantTag);
        return persistantTag;
    }
}

