/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.registries.GameData;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

abstract class TombstoneCommand {
    private final CommandDispatcher<CommandSource> commandDispatcher;
    static final String PLAYER_PARAM = "player";
    static final String TARGET_PARAM = "target";
    static final String UUID_PARAM = "uuid";
    static final String BIOME_PARAM = "biome";
    static final String STRUCTURE_PARAM = "structure";
    static final String DIM_PARAM = "dim";
    static final String AMOUNT_PARAM = "amount";
    static final SuggestionProvider<CommandSource> SUGGESTION_STRUCTURE = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)GameData.getStructureFeatures().func_148742_b(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> SUGGESTION_BIOME = (ctx, build) -> ISuggestionProvider.func_197014_a((Iterable)Registry.field_212624_m.func_148742_b(), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> SUGGESTION_DIM_IDS = (ctx, build) -> ISuggestionProvider.func_197013_a(DimensionManager.getRegistry().func_201756_e().map(dim -> String.valueOf(dim.func_186068_a())), (SuggestionsBuilder)build);
    static final SuggestionProvider<CommandSource> AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(1, () -> "[0-MAX]").buildFuture();

    public TombstoneCommand(CommandDispatcher<CommandSource> commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    abstract String getName();

    private ITextComponent getUsage() {
        return new TranslationTextComponent("tombstone.command." + this.getName() + ".usage", new Object[0]);
    }

    public int getPermissionLevel() {
        return 2;
    }

    public int showUsage(CommandSource source) {
        source.func_197030_a(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> var1);

    public void registerCommand() {
        this.commandDispatcher.register(this.getBuilder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(p -> p.func_197034_c(this.getPermissionLevel())))));
    }

    static void checkAlive(Entity entity) {
        if (!entity.func_70089_S()) {
            throw LangKey.MESSAGE_DEAD_ENTITY.asCommandException(new Object[0]);
        }
    }

    static void checkNotSpectator(Entity entity) {
        if (entity instanceof PlayerEntity) {
            TombstoneCommand.checkNotSpectator((PlayerEntity)entity);
        }
    }

    static void checkNotSpectator(PlayerEntity player) {
        if (EntityHelper.isValidPlayer(player) && player.func_175149_v()) {
            throw LangKey.MESSAGE_PLAYER_SPECTATOR.asCommandException(new Object[0]);
        }
    }

    static void checkValidPos(World world, BlockPos pos) {
        if (!Helper.isValidPos(world, pos)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
    }

    DimensionType getOrThrowDimensionType(int dim) {
        DimensionType dimensionType = DimensionType.func_186069_a((int)dim);
        if (dimensionType == null) {
            throw LangKey.MESSAGE_NO_DIMENSION.asCommandException(new Object[0]);
        }
        return dimensionType;
    }

    Biome getOrThrowBiome(CommandContext<CommandSource> context, String name) {
        ResourceLocation rl = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        return (Biome)Registry.field_212624_m.func_218349_b(rl).orElseThrow(() -> LangKey.MESSAGE_INVALID_BIOME.asCommandException(new Object[0]));
    }

    protected void sendMessage(CommandSource source, ITextComponent message, boolean allowLogging) {
        source.func_197030_a(message.func_150255_a(StyleType.TOOLTIP_DESC), allowLogging);
    }

    void runNextTick(Runnable runnable) {
        CallbackHandler.addCallback(1, runnable);
    }

    private static CommandExceptionType createCommandExceptionType(LangKey langKey) {
        return new SimpleCommandExceptionType((Message)langKey.getTranslation(new Object[0]));
    }

    private static CommandExceptionType createDynamicCommandExceptionType(LangKey langKey) {
        return new DynamicCommandExceptionType(xva$0 -> langKey.getTranslation(xva$0));
    }
}

