/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBRequestTeleport
extends TombstoneCommand {
    public CommandTBRequestTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbrequestteleport";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.requestTeleport((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"target"))));
    }

    private int requestTeleport(CommandSource sender, ServerPlayerEntity target) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownRequestTeleport.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayerEntity player = sender.func_197035_h();
        if (player.equals((Object)target)) {
            throw LangKey.MESSAGE_TELEPORT_SAME_PLAYER.asCommandException(new Object[0]);
        }
        CommandTBRequestTeleport.checkAlive((Entity)target);
        CommandTBRequestTeleport.checkNotSpectator((PlayerEntity)target);
        int cd = CooldownHandler.INSTANCE.getCooldown((PlayerEntity)player, CooldownType.REQUEST_TELEPORT);
        if (cd > 0) {
            int[] timeArray = TimeHelper.getTimeArray(cd);
            player.func_145747_a(LangKey.MESSAGE_COMMAND_IN_COOLDOWN.getTranslation(timeArray[0], timeArray[1], timeArray[2]));
            return 0;
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.REQUEST_TELEPORT);
        CommandTBAcceptTeleport.addTicket((PlayerEntity)target, (PlayerEntity)player, Math.max(120, (Integer)ConfigTombstone.general.cooldownRequestTeleport.get() * 60));
        ITextComponent hereClick = LangKey.createComponentCommand((PlayerEntity)target, "/tbacceptteleport " + player.func_110124_au(), LangKey.MESSAGE_HERE, new Object[0]);
        target.func_145747_a(LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.getTranslation(hereClick, player.func_200200_C_()).func_150255_a(StyleType.MESSAGE_SPECIAL));
        player.func_145747_a(LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.getTranslation(target.func_200200_C_()));
        return 1;
    }
}

