/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common;

import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import top.theillusivec4.colytra.common.ColytraConfig;

public class ElytraNBT {
    public static final String ELYTRA_TAG = "colytra:ElytraUpgrade";

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.func_179543_a(ELYTRA_TAG) != null;
    }

    public static ItemStack getElytra(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a(ELYTRA_TAG);
        return tag != null ? ItemStack.func_199557_a((CompoundNBT)tag) : ItemStack.field_190927_a;
    }

    public static void setElytra(ItemStack chestStack, ItemStack elytraStack) {
        chestStack.func_196082_o().func_218657_a(ELYTRA_TAG, (INBT)elytraStack.func_77955_b(new CompoundNBT()));
    }

    public static void damageElytra(LivingEntity livingEntity, ItemStack chestStack, ItemStack elytraStack, int amount) {
        ColytraConfig.ColytraMode colytraMode = ColytraConfig.getColytraMode();
        if (colytraMode == ColytraConfig.ColytraMode.NORMAL) {
            elytraStack.func_222118_a(amount, livingEntity, damager -> damager.func_213361_c(EquipmentSlotType.CHEST));
        } else if (colytraMode == ColytraConfig.ColytraMode.UNISON) {
            LazyOptional energyStorage = chestStack.getCapability(CapabilityEnergy.ENERGY);
            energyStorage.ifPresent(energy -> energy.extractEnergy(ColytraConfig.getEnergyUsage(), false));
            if (!energyStorage.isPresent()) {
                elytraStack.func_222118_a(amount, livingEntity, damager -> damager.func_213361_c(EquipmentSlotType.CHEST));
            }
        }
        ElytraNBT.setElytra(chestStack, elytraStack);
    }

    public static boolean isUseable(ItemStack chestStack, ItemStack elytraStack) {
        if (elytraStack.func_190926_b()) {
            return false;
        }
        ColytraConfig.ColytraMode colytraMode = ColytraConfig.getColytraMode();
        if (colytraMode == ColytraConfig.ColytraMode.NORMAL) {
            return elytraStack.func_77973_b() instanceof ElytraItem && ElytraItem.func_185069_d((ItemStack)elytraStack);
        }
        if (colytraMode == ColytraConfig.ColytraMode.UNISON) {
            LazyOptional energyStorage = chestStack.getCapability(CapabilityEnergy.ENERGY);
            if (energyStorage.isPresent()) {
                return (Boolean)energyStorage.map(energy -> energy.canExtract() && energy.getEnergyStored() > ColytraConfig.getEnergyUsage()).orElse((Object)false);
            }
            return !chestStack.func_77984_f() || chestStack.func_77952_i() < chestStack.func_77958_k() - 1;
        }
        return true;
    }
}

