/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.client;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.colytra.common.ColytraConfig;
import top.theillusivec4.colytra.common.ElytraNBT;

public class EventHandlerClient {
    private static void getColytraTooltip(ItemStack chestStack, List<ITextComponent> tooltip) {
        if (!ElytraNBT.hasUpgrade(chestStack)) {
            return;
        }
        ItemStack elytraStack = ElytraNBT.getElytra(chestStack);
        if (elytraStack.func_190926_b()) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent("item.minecraft.elytra", new Object[0]).func_211708_a(TextFormatting.AQUA));
        if (ColytraConfig.getColytraMode() == ColytraConfig.ColytraMode.NORMAL) {
            if (elytraStack.func_77942_o()) {
                int i = 0;
                CompoundNBT tag = elytraStack.func_77978_p();
                if (tag != null && tag.func_150297_b("HideFlags", 99)) {
                    i = tag.func_74762_e("HideFlags");
                }
                if (!(i & true)) {
                    ListNBT nbttaglist = elytraStack.func_77986_q();
                    for (int j = 0; j < nbttaglist.size(); ++j) {
                        CompoundNBT nbttagcompound = nbttaglist.func_150305_b(j);
                        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)nbttagcompound.func_74779_i("id")));
                        if (enchantment == null) continue;
                        tooltip.add(new StringTextComponent(" ").func_150257_a(enchantment.func_200305_d(nbttagcompound.func_74762_e("lvl"))));
                    }
                }
            }
            if (ElytraNBT.isUseable(chestStack, elytraStack)) {
                tooltip.add(new StringTextComponent(" ").func_150257_a((ITextComponent)new TranslationTextComponent("item.durability", new Object[]{elytraStack.func_77958_k() - elytraStack.func_77952_i(), elytraStack.func_77958_k()})));
            } else {
                tooltip.add(new StringTextComponent(" ").func_150257_a(new TranslationTextComponent("tooltip.colytra.broken", new Object[0]).func_211708_a(TextFormatting.RED)));
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent evt) {
        ItemStack itemstack = evt.getItemStack();
        List tooltip = evt.getToolTip();
        EventHandlerClient.getColytraTooltip(itemstack, tooltip);
    }
}

