/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra;

import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.caelus.api.CaelusAPI;
import top.theillusivec4.colytra.client.EventHandlerClient;
import top.theillusivec4.colytra.common.ColytraConfig;
import top.theillusivec4.colytra.common.ElytraNBT;
import top.theillusivec4.colytra.common.EventHandlerCommon;
import top.theillusivec4.colytra.common.crafting.ElytraAttachmentRecipe;
import top.theillusivec4.colytra.common.crafting.ElytraDetachmentRecipe;

@Mod(value="colytra")
public class Colytra {
    public static final String MODID = "colytra";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String ATTACH_ELYTRA = "elytra_attachment";
    private static final String DETACH_ELYTRA = "elytra_detachment";

    public Colytra() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ColytraConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"caelus", (String)"elytraRender", () -> livingEntity -> {
            ItemStack stack = livingEntity.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack elytraStack = ElytraNBT.getElytra(stack);
            if (!elytraStack.func_190926_b()) {
                return elytraStack.func_77948_v() ? CaelusAPI.ElytraRender.ENCHANTED : CaelusAPI.ElytraRender.NORMAL;
            }
            return CaelusAPI.ElytraRender.NONE;
        });
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRecipeSerializerRegistry(RegistryEvent.Register<IRecipeSerializer<?>> evt) {
            ElytraAttachmentRecipe.CRAFTING_ATTACH_ELYTRA.setRegistryName(Colytra.ATTACH_ELYTRA);
            ElytraDetachmentRecipe.CRAFTING_DETACH_ELYTRA.setRegistryName(Colytra.DETACH_ELYTRA);
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{ElytraAttachmentRecipe.CRAFTING_ATTACH_ELYTRA, ElytraDetachmentRecipe.CRAFTING_DETACH_ELYTRA});
        }
    }
}

