/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import java.util.function.Supplier;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestFilterGUI {
    private final BlockPos pos;
    private final int rootFilterIndex;

    public MessageRequestFilterGUI(BlockPos pos, int rootFilterIndex) {
        this.pos = pos;
        this.rootFilterIndex = rootFilterIndex;
    }

    public static void encode(MessageRequestFilterGUI message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeByte(message.rootFilterIndex);
    }

    public static MessageRequestFilterGUI decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        byte rootFilterIndex = buf.readByte();
        return new MessageRequestFilterGUI(pos, rootFilterIndex);
    }

    public static void handle(MessageRequestFilterGUI message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
            if (tileEntity != null) {
                RefinedRelocationAPI.openRootFilterGui((PlayerEntity)player, tileEntity, message.rootFilterIndex);
            }
        });
        context.setPacketHandled(true);
    }
}

