/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.container.NameFilterContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NameFilter
implements IFilter {
    public static final String ID = "refinedrelocation:name_filter";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[^*]+|(\\*)");
    private static final Matcher WILDCARD_MATCHER = WILDCARD_PATTERN.matcher("");
    private String value = "";
    private Pattern[] cachedPatterns;
    private NameFilterType[] cachedNameFilterType;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        String itemName = null;
        Collection tags = null;
        Pattern[] patterns = this.getPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            if (pattern == null) continue;
            if (this.cachedNameFilterType[i] == NameFilterType.TAG) {
                if (tags == null) {
                    tags = ItemTags.func_199903_a().func_199913_a((Object)itemStack.func_77973_b());
                }
                Matcher matcher = pattern.matcher("");
                for (ResourceLocation tag : tags) {
                    matcher.reset(tag.toString());
                    if (matcher.matches()) {
                        return true;
                    }
                    matcher.reset(tag.func_110623_a());
                    if (!matcher.matches()) continue;
                    return true;
                }
                continue;
            }
            if (this.cachedNameFilterType[i] == NameFilterType.MOD) {
                Matcher matcher;
                ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
                if (registryName == null || !(matcher = pattern.matcher(registryName.func_110624_b())).matches()) continue;
                return true;
            }
            if (itemName == null) {
                itemName = itemStack.func_200301_q().func_150261_e();
            }
            if (!pattern.matcher(itemName).matches()) continue;
            return true;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
        this.cachedPatterns = null;
    }

    public String getValue() {
        return this.value;
    }

    public Pattern[] getPatterns() {
        if (this.cachedPatterns == null) {
            String[] patternsSplit = this.value.split("[\n,]");
            this.cachedPatterns = new Pattern[patternsSplit.length];
            this.cachedNameFilterType = new NameFilterType[patternsSplit.length];
            for (int i = 0; i < patternsSplit.length; ++i) {
                if ((patternsSplit[i].startsWith("tag:") || patternsSplit[i].startsWith("ore:")) && patternsSplit[i].length() > 4) {
                    patternsSplit[i] = patternsSplit[i].substring(4);
                    this.cachedNameFilterType[i] = NameFilterType.TAG;
                } else if (patternsSplit[i].startsWith("mod:") && patternsSplit[i].length() > 4) {
                    patternsSplit[i] = patternsSplit[i].substring(4).toLowerCase(Locale.ENGLISH).replace(' ', '*');
                    this.cachedNameFilterType[i] = NameFilterType.MOD;
                }
                WILDCARD_MATCHER.reset(patternsSplit[i]);
                StringBuffer sb = new StringBuffer();
                while (WILDCARD_MATCHER.find()) {
                    if (WILDCARD_MATCHER.group(1) != null) {
                        WILDCARD_MATCHER.appendReplacement(sb, ".*");
                        continue;
                    }
                    WILDCARD_MATCHER.appendReplacement(sb, "\\\\Q" + WILDCARD_MATCHER.group(0) + "\\\\E");
                }
                WILDCARD_MATCHER.appendTail(sb);
                try {
                    this.cachedPatterns[i] = Pattern.compile(sb.toString());
                    continue;
                }
                catch (PatternSyntaxException e) {
                    RefinedRelocation.logger.error("Caught an exception in the pattern compilation for the Name Filter. This should never happen, please report: {} => {}", (Object)patternsSplit[i], (Object)sb.toString());
                }
            }
        }
        return this.cachedPatterns;
    }

    public INBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Patterns", this.value);
        return compound;
    }

    public void deserializeNBT(INBT nbt) {
        CompoundNBT compound = (CompoundNBT)nbt;
        this.value = compound.func_74779_i("Patterns");
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:name_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:name_filter.description";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDrawable getFilterIcon() {
        return GuiTextures.NAME_FILTER_ICON;
    }

    @Override
    public int getVisualOrder() {
        return 900;
    }

    @Override
    @Nullable
    public INamedContainerProvider getConfiguration(PlayerEntity player, final TileEntity tileEntity, final int rootFilterIndex) {
        return new INamedContainerProvider(){

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new NameFilterContainer(i, playerInventory, tileEntity, rootFilterIndex, NameFilter.this);
            }

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("refinedrelocation:any_filter", new Object[0]);
            }
        };
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    public static enum NameFilterType {
        NAME,
        TAG,
        MOD;

    }
}

