/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import java.util.Collection;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.container.ChecklistFilterContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CreativeTabFilter
implements IChecklistFilter {
    public static final String ID = "refinedrelocation:creative_tab_filter";
    private static final int IGNORED_TABS = 3;
    public static String[] creativeTabs = new String[0];
    private final boolean[] tabStates = new boolean[creativeTabs.length];

    public static void gatherCreativeTabs() {
        creativeTabs = new String[ItemGroup.field_78032_a.length - 3];
        int i = 0;
        for (int j = 0; j < ItemGroup.field_78032_a.length; ++j) {
            if (ItemGroup.field_78032_a[j] == ItemGroup.field_78036_m || ItemGroup.field_78032_a[j] == ItemGroup.field_78027_g || ItemGroup.field_78032_a[j] == ItemGroup.field_192395_m) continue;
            CreativeTabFilter.creativeTabs[i] = ItemGroup.field_78032_a[j].field_78034_o;
            ++i;
        }
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        Collection itemTabs = itemStack.func_77973_b().getCreativeTabs();
        for (ItemGroup itemTab : itemTabs) {
            if (itemTab == null) continue;
            int shiftedTabIndex = itemTab.field_78033_n;
            if (itemTab.field_78033_n >= ItemGroup.field_78027_g.field_78033_n) {
                --shiftedTabIndex;
            }
            if (itemTab.field_78033_n >= ItemGroup.field_78036_m.field_78033_n) {
                --shiftedTabIndex;
            }
            if (itemTab.field_78033_n >= ItemGroup.field_192395_m.field_78033_n) {
                --shiftedTabIndex;
            }
            if (!this.tabStates[shiftedTabIndex]) continue;
            return true;
        }
        return false;
    }

    public INBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.tabStates.length; ++i) {
            if (!this.tabStates[i]) continue;
            list.add((Object)StringNBT.func_229705_a_((String)creativeTabs[i]));
        }
        return list;
    }

    public void deserializeNBT(INBT nbt) {
        ListNBT list = (ListNBT)nbt;
        for (int i = 0; i < list.size(); ++i) {
            String tabLabel = list.func_150307_f(i);
            for (int j = 0; j < creativeTabs.length; ++j) {
                if (!creativeTabs[j].equals(tabLabel)) continue;
                this.tabStates[j] = true;
            }
        }
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:creative_tab_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:creative_tab_filter.description";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDrawable getFilterIcon() {
        return GuiTextures.CREATIVE_TAB_FILTER_ICON;
    }

    @Override
    public String getOptionLangKey(int option) {
        return "itemGroup." + creativeTabs[option];
    }

    @Override
    public void setOptionChecked(int option, boolean checked) {
        this.tabStates[option] = checked;
    }

    @Override
    public boolean isOptionChecked(int option) {
        return this.tabStates[option];
    }

    @Override
    public int getOptionCount() {
        return creativeTabs.length;
    }

    @Override
    public int getVisualOrder() {
        return 700;
    }

    @Override
    @Nullable
    public INamedContainerProvider getConfiguration(PlayerEntity player, final TileEntity tileEntity, final int rootFilterIndex) {
        return new INamedContainerProvider(){

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ChecklistFilterContainer(i, playerInventory, tileEntity, rootFilterIndex, CreativeTabFilter.this);
            }

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.refinedrelocation:creativeTabFilter", new Object[0]);
            }
        };
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }
}

