/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.container.BaseContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BlockExtenderContainer
extends BaseContainer {
    public static final String KEY_TOGGLE_SIDE = "ToggleSide";
    public static final String KEY_SIDE_INDEX = "SideIndex";
    public static final String KEY_SIDE_MAPPING = "SideMapping";
    public static final String KEY_STACK_LIMITER = "StackLimiter";
    public static final String KEY_CONFIGURE_INPUT_FILTER = "ConfigureInputFilter";
    public static final String KEY_CONFIGURE_OUTPUT_FILTER = "ConfigureOutputFilter";
    private final PlayerEntity player;
    private final TileBlockExtender tileEntity;
    private final Direction[] lastSideMapping = new Direction[5];
    private int lastStackLimiterLimit;

    public BlockExtenderContainer(int windowId, PlayerInventory playerInventory, TileBlockExtender tileEntity) {
        super(ModContainers.blockExtender, windowId);
        this.player = playerInventory.field_70458_d;
        this.tileEntity = tileEntity;
        for (int i = 0; i < 3; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.getItemHandlerUpgrades(), i, 152, 22 + i * 18));
        }
        this.addPlayerInventory(playerInventory, 8, 94);
    }

    public TileBlockExtender getTileEntity() {
        return this.tileEntity;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.lastSideMapping.length; ++i) {
            Direction nowSideMapping = this.tileEntity.getSideMapping(RelativeSide.fromIndex(i));
            if (this.lastSideMapping[i] == nowSideMapping) continue;
            CompoundNBT compound = new CompoundNBT();
            compound.func_74774_a(KEY_SIDE_INDEX, (byte)i);
            compound.func_74774_a(KEY_SIDE_MAPPING, nowSideMapping != null ? (byte)nowSideMapping.func_176745_a() : (byte)-1);
            RefinedRelocationAPI.syncContainerValue(KEY_SIDE_MAPPING, compound, (Iterable<IContainerListener>)this.field_75149_d);
            this.lastSideMapping[i] = nowSideMapping;
        }
        int nowStackLimiterLimit = this.tileEntity.getStackLimiterLimit();
        if (this.lastStackLimiterLimit != nowStackLimiterLimit) {
            RefinedRelocationAPI.syncContainerValue(KEY_STACK_LIMITER, this.tileEntity.getStackLimiterLimit(), (Iterable<IContainerListener>)this.field_75149_d);
            this.lastStackLimiterLimit = nowStackLimiterLimit;
        }
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        switch (message.getKey()) {
            case "ToggleSide": {
                RelativeSide side = RelativeSide.fromIndex(message.getIndex());
                if (side == RelativeSide.FRONT) break;
                int facingIdx = message.getIntValue();
                Direction facing = facingIdx == -1 ? null : Direction.func_82600_a((int)facingIdx);
                this.tileEntity.setSideMapping(side, facing);
                this.lastSideMapping[side.ordinal()] = facing;
                break;
            }
            case "StackLimiter": {
                int stackSizeLimit = MathHelper.func_76125_a((int)message.getIntValue(), (int)1, (int)Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a));
                this.tileEntity.setStackLimiterLimit(stackSizeLimit);
                this.lastStackLimiterLimit = stackSizeLimit;
                break;
            }
            case "ConfigureInputFilter": {
                this.tileEntity.getInputFilter().ifPresent(it -> {
                    INamedContainerProvider config = it.getConfiguration(this.player, this.tileEntity, 0);
                    if (config != null) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.player), (INamedContainerProvider)config, (BlockPos)this.tileEntity.func_174877_v());
                    }
                });
                break;
            }
            case "ConfigureOutputFilter": {
                this.tileEntity.getOutputFilter().ifPresent(it -> {
                    INamedContainerProvider config = it.getConfiguration(this.player, this.tileEntity, 1);
                    if (config != null) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.player), (INamedContainerProvider)config, (BlockPos)this.tileEntity.func_174877_v());
                    }
                });
            }
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_SIDE_MAPPING)) {
            CompoundNBT compound = message.getNBTValue();
            this.tileEntity.setSideMapping(RelativeSide.fromIndex(compound.func_74771_c(KEY_SIDE_INDEX)), Direction.func_82600_a((int)compound.func_74771_c(KEY_SIDE_MAPPING)));
        } else if (message.getKey().equals(KEY_STACK_LIMITER)) {
            this.tileEntity.setStackLimiterLimit(message.getIntValue());
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 3) {
                if (!this.func_75135_a(slotStack, 3, 30, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index < 30) {
                if (!this.func_75135_a(slotStack, 0, 3, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, 0, 30, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return !this.tileEntity.func_145837_r() && player.func_70092_e((double)this.tileEntity.func_174877_v().func_177958_n() + 0.5, (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public Slot getUpgradeSlot(int i) {
        return (Slot)this.field_75151_b.get(i);
    }
}

