/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.RootFilterScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiFilterSlot
extends Button
implements ITooltipElement {
    private final RootFilterScreen parentGui;
    private final IDrawable texture;
    private final IRootFilter rootFilter;
    private final int index;

    public GuiFilterSlot(int x, int y, RootFilterScreen parentGui, IRootFilter rootFilter, int index) {
        super(x, y, 24, 24, "", it -> {});
        this.parentGui = parentGui;
        this.rootFilter = rootFilter;
        this.index = index;
        this.texture = GuiTextures.FILTER_SLOT;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        IDrawable filterIcon;
        this.texture.bind();
        this.texture.draw(this.x, this.y, this.getBlitOffset());
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter != null && (filterIcon = filter.getFilterIcon()) != null) {
            filterIcon.draw(this.x, this.y, 24.0, 24.0, this.getBlitOffset());
        }
        if (this.parentGui.isTopMostElement((Widget)this, mouseX, mouseY)) {
            GuiFilterSlot.fill((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.width - 1), (int)(this.y + this.height - 1), (int)-1711276033);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter == null) {
            RefinedRelocationAPI.sendContainerMessageToServer("OpenAddFilter", 0);
        } else {
            RefinedRelocationAPI.sendContainerMessageToServer("EditFilter", this.index);
        }
    }

    @Override
    public void addTooltip(List<String> list) {
        IFilter filter = this.rootFilter.getFilter(this.index);
        if (filter == null) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.no_filter_set", (Object[])new Object[0]));
            list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_add_filter", (Object[])new Object[0]));
        } else {
            list.add(I18n.func_135052_a((String)filter.getLangKey(), (Object[])new Object[0]));
            if (filter.hasConfiguration()) {
                list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_configure", (Object[])new Object[0]));
            } else {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.not_configurable", (Object[])new Object[0]));
            }
        }
    }

    public int getFilterIndex() {
        return this.index;
    }

    public boolean hasFilter() {
        return this.rootFilter.getFilter(this.index) != null;
    }
}

