/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class GuiChecklistEntry
extends Button {
    private final IChecklistFilter filter;
    private final IDrawable texture;
    private final IDrawable textureChecked;
    private int currentOption = -1;

    public GuiChecklistEntry(int x, int y, IChecklistFilter filter) {
        super(x, y, 151, 11, "", it -> {});
        this.filter = filter;
        this.texture = GuiTextures.CHECKLIST;
        this.textureChecked = GuiTextures.CHECKLIST_CHECKED;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.currentOption != -1) {
            boolean oldState = this.filter.isOptionChecked(this.currentOption);
            this.filter.setOptionChecked(this.currentOption, !oldState);
            if (!oldState) {
                RefinedRelocationAPI.sendContainerMessageToServer("Check", this.currentOption);
            } else {
                RefinedRelocationAPI.sendContainerMessageToServer("Uncheck", this.currentOption);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            GuiChecklistEntry.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x66FFFFFF);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentOption != -1) {
            this.texture.bind();
            if (this.filter.isOptionChecked(this.currentOption)) {
                this.textureChecked.draw(this.x + 1, (float)this.y + (float)this.height / 2.0f - 5.5f, this.getBlitOffset());
            } else {
                this.texture.draw(this.x + 1, (float)this.y + (float)this.height / 2.0f - 5.5f, this.getBlitOffset());
            }
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String string = I18n.func_135052_a((String)this.filter.getOptionLangKey(this.currentOption), (Object[])new Object[0]);
            int n = this.y + this.height / 2;
            fontRenderer.getClass();
            this.drawString(fontRenderer, string, this.x + 14, n - 9 / 2, 0xFFFFFF);
        }
    }

    public void setCurrentOption(int currentOption) {
        this.currentOption = currentOption;
    }
}

