/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.block.SortingChestBlock;
import net.blay09.mods.refinedrelocation.tile.FastHopperTileEntity;
import net.blay09.mods.refinedrelocation.tile.FilteredHopperTileEntity;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.tile.TileSortingConnector;
import net.blay09.mods.refinedrelocation.tile.TileSortingInterface;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModTileEntities {
    public static List<TileEntityType<SortingChestTileEntity>> sortingChests;
    public static TileEntityType<TileBlockExtender> blockExtender;
    public static TileEntityType<FastHopperTileEntity> fastHopper;
    public static TileEntityType<FilteredHopperTileEntity> filteredHopper;
    public static TileEntityType<TileSortingConnector> sortingConnector;
    public static TileEntityType<TileSortingInterface> sortingInterface;

    public static void registerTileEntities(IForgeRegistry<TileEntityType<?>> registry) {
        sortingChests = new ArrayList<TileEntityType<SortingChestTileEntity>>();
        for (SortingChestBlock sortingChest : ModBlocks.sortingChests) {
            TileEntityType<SortingChestTileEntity> tileEntityType = ModTileEntities.build(() -> new SortingChestTileEntity(sortingChest.getChestType()), (Block)sortingChest);
            sortingChests.add(tileEntityType);
            registry.register(tileEntityType);
        }
        TileEntityType[] tileEntityTypeArray = new TileEntityType[5];
        blockExtender = ModTileEntities.build(TileBlockExtender::new, ModBlocks.blockExtender);
        tileEntityTypeArray[0] = blockExtender;
        fastHopper = ModTileEntities.build(FastHopperTileEntity::new, ModBlocks.fastHopper);
        tileEntityTypeArray[1] = fastHopper;
        filteredHopper = ModTileEntities.build(FilteredHopperTileEntity::new, ModBlocks.filteredHopper);
        tileEntityTypeArray[2] = filteredHopper;
        sortingConnector = ModTileEntities.build(TileSortingConnector::new, ModBlocks.sortingConnector);
        tileEntityTypeArray[3] = sortingConnector;
        sortingInterface = ModTileEntities.build(TileSortingInterface::new, ModBlocks.sortingInterface);
        tileEntityTypeArray[4] = sortingInterface;
        registry.registerAll((IForgeRegistryEntry[])tileEntityTypeArray);
    }

    private static <T extends TileEntity> TileEntityType<T> build(Supplier<T> factory, Block block) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            throw new IllegalArgumentException("Block passed into tile entity registration is not registered correctly");
        }
        return (TileEntityType)TileEntityType.Builder.func_223042_a(factory, (Block[])new Block[]{block}).func_206865_a(null).setRegistryName(registryName);
    }
}

