/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.item.CraftingItems;
import net.silentchaos512.supermultidrills.item.DrillBatteryItem;
import net.silentchaos512.supermultidrills.item.DrillChassisItem;
import net.silentchaos512.supermultidrills.item.DrillHeadItem;
import net.silentchaos512.supermultidrills.item.DrillItem;

public final class ModItems {
    public static DrillItem drill;
    public static DrillHeadItem drillHead;
    public static DrillChassisItem drillChassis;
    public static GearBlueprintItem drillBlueprint;
    public static final List<Item> ALL_ITEMS;
    public static final List<DrillBatteryItem> BATTERIES;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        drillBlueprint = ModItems.register("drill_blueprint", new GearBlueprintItem(false, () -> drill, new Item.Properties().func_200916_a(SuperMultiDrills.ITEM_GROUP)));
        drill = ModItems.register("drill", new DrillItem());
        net.silentchaos512.gear.init.ModItems.gearClasses.put(SuperMultiDrills.getId("drill"), drill);
        drillHead = ModItems.register("drill_head", new DrillHeadItem());
        net.silentchaos512.gear.init.ModItems.gearClasses.put(SuperMultiDrills.getId("drill_head"), drillHead);
        drillChassis = ModItems.register("drill_chassis", new DrillChassisItem());
        ModItems.register("tater_battery", ModItems.getBattery(2000, 20));
        ModItems.register("small_battery", ModItems.getBattery(20000, 200));
        ModItems.register("medium_battery", ModItems.getBattery(200000, 2000));
        ModItems.register("large_battery", ModItems.getBattery(2000000, 20000));
        ModItems.register("extreme_battery", ModItems.getBattery(20000000, 200000));
        for (CraftingItems item : CraftingItems.values()) {
            ModItems.register(item.getName(), item.func_199767_j());
        }
    }

    private static <T extends Item> T register(String name, T item) {
        ResourceLocation id = SuperMultiDrills.getId(name);
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        ALL_ITEMS.add(item);
        return item;
    }

    private static DrillBatteryItem getBattery(int capacity, int transferRate) {
        DrillBatteryItem item = new DrillBatteryItem(capacity, transferRate);
        BATTERIES.add(item);
        return item;
    }

    static {
        ALL_ITEMS = new ArrayList<Item>();
        BATTERIES = new ArrayList<DrillBatteryItem>();
    }
}

