/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket {
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
    }

    public RingOfFirePacket(PlayerEntity player) {
        super(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void showFireRing(World world, Vec3d pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double x = pos.field_72450_a;
            double y = pos.field_72448_b;
            double z = pos.field_72449_c;
            double particleX = x + xOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleY = y + yOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleZ = z + zOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.field_73012_v.nextInt(20) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                continue;
            }
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @Override
    protected PlayerPositionPacket create(PlayerEntity player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected ModBase getModInstance() {
        return CyclopsCore._instance;
    }

    @Override
    protected void performClientAction(World world, PlayerEntity player) {
        RingOfFirePacket.showFireRing(world, this.position);
    }
}

