/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.base.Predicates;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandler {
    private final ModBase mod;
    private SimpleChannel networkChannel = null;

    public PacketHandler(ModBase mod) {
        this.mod = mod;
    }

    public void init() {
        if (this.networkChannel == null) {
            this.networkChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(this.mod.getModId(), "channel_main"), () -> "1.0.0", (Predicate)Predicates.alwaysTrue(), (Predicate)Predicates.alwaysTrue());
        }
    }

    public <P extends PacketBase> void register(Class<P> packetType) {
        int discriminator = Helpers.getNewId(this.mod, Helpers.IDType.PACKET);
        try {
            Constructor constructor = packetType.getConstructor(new Class[0]);
            this.networkChannel.registerMessage(discriminator, packetType, (packet, packetBuffer) -> packet.encode((PacketBuffer)packetBuffer), packetBuffer -> {
                PacketBase packet = null;
                try {
                    packet = (PacketBase)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                packet.decode((PacketBuffer)packetBuffer);
                return packet;
            }, (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (context.getDirection().getReceptionSide().isClient()) {
                    if (packet.isAsync()) {
                        this.handlePacketClient(context, (PacketBase)packet);
                    } else {
                        context.enqueueWork(() -> this.handlePacketClient(context, (PacketBase)packet));
                    }
                } else if (packet.isAsync()) {
                    this.handlePacketServer(context, (PacketBase)packet);
                } else {
                    context.enqueueWork(() -> this.handlePacketServer(context, (PacketBase)packet));
                }
                context.setPacketHandled(true);
            });
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            CyclopsCore.clog(Level.ERROR, "Could not find a default constructor for packet " + packetType.getName());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketClient(NetworkEvent.Context context, PacketBase packet) {
        packet.actionClient(Minecraft.func_71410_x().field_71439_g.field_70170_p, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void handlePacketServer(NetworkEvent.Context context, PacketBase packet) {
        packet.actionServer((World)context.getSender().func_71121_q(), context.getSender());
    }

    public void sendToServer(PacketBase packet) {
        this.networkChannel.sendToServer((Object)packet);
    }

    public void sendToPlayer(PacketBase packet, ServerPlayerEntity player) {
        this.networkChannel.sendTo((Object)packet, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToAllAround(PacketBase packet, PacketDistributor.TargetPoint point) {
        PacketDistributor.PacketTarget target = PacketDistributor.NEAR.with(() -> point);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }

    public void sendToDimension(PacketBase packet, DimensionType dimension) {
        PacketDistributor.PacketTarget target = PacketDistributor.DIMENSION.with(() -> dimension);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }

    public void sendToAll(PacketBase packet) {
        PacketDistributor.PacketTarget target = PacketDistributor.ALL.with(() -> null);
        target.send(this.networkChannel.toVanillaPacket((Object)packet, target.getDirection()));
    }
}

