/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.recipe.handler;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeInputDefinitionHandler;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeOutputDefinitionHandler;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;

public class IngredientRecipeComponentHandler
implements IRecipeInputDefinitionHandler<IngredientRecipeComponent>,
IRecipeOutputDefinitionHandler<IngredientRecipeComponent> {
    @Override
    public IMixedIngredients toRecipeDefinitionOutput(IngredientRecipeComponent recipeOutput) {
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!recipeOutput.getItemStacks().isEmpty() && recipeOutput.getChance() == 1.0f) {
            outputs.put(IngredientComponent.ITEMSTACK, Collections.singletonList(recipeOutput.getFirstItemStack()));
        }
        return new MixedIngredients((Map)outputs);
    }

    @Override
    public Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> toRecipeDefinitionInput(IngredientRecipeComponent recipeInput) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List<ItemStack> itemStacks = recipeInput.getItemStacks();
        if (!itemStacks.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, Collections.singletonList(new PrototypedIngredientAlternativesList(itemStacks.stream().map(itemStack -> new PrototypedIngredient(IngredientComponent.ITEMSTACK, itemStack, (Object)1)).collect(Collectors.toList()))));
        }
        return inputs;
    }
}

