/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class ModelHelpers {
    public static final Map<Direction, List<BakedQuad>> EMPTY_FACE_QUADS = Maps.newHashMap();

    public static BlockModel loadModelBlock(ResourceLocation modelLocation) throws IOException {
        IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), Charsets.UTF_8);
        return BlockModel.func_178307_a((Reader)reader);
    }

    public static <T> T getSafeProperty(@Nullable IModelData modelData, ModelProperty<T> property, T fallback) {
        Object value;
        if (modelData == null) {
            return fallback;
        }
        try {
            value = modelData.getData(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    static {
        for (Direction facing : Direction.values()) {
            EMPTY_FACE_QUADS.put(facing, Collections.emptyList());
        }
    }
}

