/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.lwjgl.opengl.GL11;

public class GuiHelpers {
    public static int SLOT_SIZE = 18;
    public static int SLOT_SIZE_INNER = 16;
    private static final List<Pair<Long, String>> COUNT_SCALES = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1000000000000000000L, (Object)"E"), Pair.of((Object)1000000000000000L, (Object)"P"), Pair.of((Object)1000000000000L, (Object)"T"), Pair.of((Object)1000000000L, (Object)"G"), Pair.of((Object)1000000L, (Object)"M"), Pair.of((Object)1000L, (Object)"K")});

    public static void renderFluidTank(AbstractGui gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height) {
        if (fluidStack != null && !fluidStack.isEmpty() && capacity > 0) {
            GlStateManager.func_227626_N_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            RenderHelper.func_227780_a_();
            GlStateManager.func_227623_K_();
            GL11.glEnable((int)2929);
            int level = (int)((double)height * ((double)fluidStack.getAmount() / (double)capacity));
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon(fluidStack, Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                RenderHelpers.bindTexture(AtlasTexture.field_110575_b);
                Triple colorParts = Helpers.intToRGB(fluidStack.getFluid().getAttributes().getColor(fluidStack));
                if (fluidStack.getFluid() == Fluids.field_204546_a || fluidStack.getFluid() == Fluids.field_207212_b) {
                    colorParts = Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.335f), (Object)Float.valueOf(1.0f));
                }
                RenderSystem.color3f((float)((Float)colorParts.getLeft()).floatValue(), (float)((Float)colorParts.getMiddle()).floatValue(), (float)((Float)colorParts.getRight()).floatValue());
                AbstractGui.blit((int)x, (int)(y - textureHeight - verticalOffset + height), (int)0, (int)width, (int)textureHeight, (TextureAtlasSprite)icon);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                verticalOffset += 16;
            }
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(AtlasTexture.field_110575_b);
            textureManager.func_229267_b_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
            RenderHelper.func_74518_a();
            GlStateManager.func_227627_O_();
            GL11.glDisable((int)2929);
        }
    }

    public static void renderFluidSlot(AbstractGui gui, @Nullable FluidStack fluidStack, int x, int y) {
        if (fluidStack != null) {
            GuiHelpers.renderFluidTank(gui, fluidStack, fluidStack.getAmount(), x, y, SLOT_SIZE_INNER, SLOT_SIZE_INNER);
        }
    }

    public static void renderOverlayedFluidTank(AbstractGui gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height, ResourceLocation textureOverlay, int overlayTextureX, int overlayTextureY) {
        GuiHelpers.renderFluidTank(gui, fluidStack, capacity, x, y, width, height);
        if (fluidStack != null && capacity > 0) {
            GlStateManager.func_227740_m_();
            RenderHelpers.bindTexture(textureOverlay);
            gui.blit(x, y, overlayTextureX, overlayTextureY, width, height);
        }
    }

    public static void renderProgressBar(AbstractGui gui, int x, int y, int width, int height, int textureX, int textureY, ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = (int)((double)scaledWidth * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = (int)((double)scaledHeight * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.blit(x, y, textureX, textureY, scaledWidth, scaledHeight);
        }
    }

    public static void drawTooltip(ContainerScreen gui, List<ITextComponent> lines, int x, int y) {
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        int width = gui.width;
        int height = gui.height;
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_227626_N_();
        GL11.glDisable((int)2929);
        GlStateManager.func_227624_L_();
        GlStateManager.func_227722_g_();
        int tooltipWidth = 0;
        for (ITextComponent line : lines) {
            int tempWidth = mc.field_71466_p.func_78256_a(line.func_150254_d());
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (guiLeft + xStart + tooltipWidth + 6 > width) {
            xStart = width - tooltipWidth - guiLeft - 6;
        }
        if (guiTop + yStart + tooltipHeight + 6 > height) {
            yStart = height - tooltipHeight - guiTop - 6;
        }
        float zLevel = 300.0f;
        mc.func_175599_af().field_77023_b = 300.0f;
        int color1 = -267386864;
        GuiHelpers.fillGradient(xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1, zLevel);
        GuiHelpers.fillGradient(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1, zLevel);
        GuiHelpers.fillGradient(xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1, zLevel);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        GuiHelpers.fillGradient(xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        GuiHelpers.fillGradient(xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3, zLevel);
        GuiHelpers.fillGradient(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2, zLevel);
        GuiHelpers.fillGradient(xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3, zLevel);
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            ITextComponent line = lines.get(stringIndex);
            line = stringIndex == 0 ? new StringTextComponent("\u00a7" + Integer.toHexString(15)).func_150257_a(line) : new StringTextComponent("\u00a77").func_150257_a(line);
            mc.field_71466_p.func_175063_a(line.func_150254_d(), (float)xStart, (float)yStart, -1);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        GlStateManager.func_227627_O_();
        GL11.glEnable((int)2929);
        mc.func_175599_af().field_77023_b = 0.0f;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_227621_I_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227700_d_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_227762_u_((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227762_u_((int)7424);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227619_H_();
    }

    public static void renderTooltipOptional(ContainerScreen gui, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<ITextComponent>>> linesSupplier) {
        if (RenderHelpers.isPointInRegion(x, y, width, height, mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop())) {
            linesSupplier.get().ifPresent(lines -> GuiHelpers.drawTooltip(gui, lines, mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop()));
        }
    }

    public static void renderTooltip(ContainerScreen gui, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<ITextComponent>> linesSupplier) {
        GuiHelpers.renderTooltipOptional(gui, x, y, width, height, mouseX, mouseY, () -> Optional.of(linesSupplier.get()));
    }

    public static String quantityToScaledString(long quantity) {
        for (Pair<Long, String> countScale : COUNT_SCALES) {
            long mod;
            long scale = (Long)countScale.getLeft();
            if (quantity < scale) continue;
            long division = quantity / scale;
            String divisionString = String.valueOf(division);
            if (division < 10L) {
                long mod2 = quantity % scale;
                if (mod2 > 0L) {
                    long digits = mod2 * 100L / scale;
                    divisionString = divisionString + "." + (digits < 10L ? "0" : "") + String.valueOf(digits);
                }
            } else if (division < 100L && (mod = quantity % scale) > 0L) {
                long digits = mod * 10L / scale;
                divisionString = divisionString + "." + String.valueOf(digits);
            }
            return divisionString + (String)countScale.getRight();
        }
        return String.valueOf(quantity);
    }

    public static enum ProgressDirection {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0),
        UP_LEFT(-1, -1),
        UP_RIGHT(1, -1),
        DOWN_LEFT(-1, 1),
        DOWN_RIGHT(1, 1);

        private final int incrementX;
        private final int incrementY;

        private ProgressDirection(int incrementX, int incrementY) {
            this.incrementX = incrementX;
            this.incrementY = incrementY;
        }

        public int getIncrementX() {
            return this.incrementX;
        }

        public int getIncrementY() {
            return this.incrementY;
        }
    }
}

