/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class CraftingHelpers {
    private static final LoadingCache<Triple<IRecipeType<?>, CacheableCraftingInventory, DimensionType>, Optional<IRecipe>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<IRecipeType<?>, CacheableCraftingInventory, DimensionType>, Optional<IRecipe>>(){

        public Optional<IRecipe> load(Triple<IRecipeType<?>, CacheableCraftingInventory, DimensionType> key) throws Exception {
            ServerWorld world = DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)((DimensionType)key.getRight()), (boolean)false, (boolean)false);
            return world.func_199532_z().func_215371_a((IRecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (World)world);
        }
    });

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> findServerRecipe(IRecipeType<T> recipeType, C container, World world) {
        return world.func_199532_z().func_215371_a(recipeType, container, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> getClientRecipe(IRecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(Minecraft.func_71410_x().func_147114_u().func_199526_e().func_215366_a(recipeType).get(recipeName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> getClientRecipes(IRecipeType<T> recipeType) {
        return Minecraft.func_71410_x().func_147114_u().func_199526_e().func_215366_a(recipeType).values();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <C extends IInventory, T extends IRecipe<C>> T findClientRecipe(ItemStack itemStack, IRecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (IRecipe recipe : CraftingHelpers.getClientRecipes(recipeType)) {
            if (!ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return (T)recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + itemStack + "::" + itemStack.func_77978_p() + " with index " + index);
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> findRecipeCached(IRecipeType<T> recipeType, C inventoryCrafting, World world, boolean uniqueInventory) {
        return (Optional)CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.func_201675_m().func_186058_p()));
    }

    public static class CacheableCraftingInventory {
        private final IInventory inventoryCrafting;

        public CacheableCraftingInventory(IInventory inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                this.inventoryCrafting = new CraftingInventory(new Container(null, 0){

                    public boolean func_75145_c(PlayerEntity playerIn) {
                        return false;
                    }
                }, inventoryCrafting.func_70302_i_(), 1);
                for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
                    this.inventoryCrafting.func_70299_a(i, inventoryCrafting.func_70301_a(i).func_77946_l());
                }
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public IInventory getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)this.getInventoryCrafting().func_70301_a(i), (ItemStack)((CacheableCraftingInventory)obj).getInventoryCrafting().func_70301_a(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().func_70302_i_();
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                hash <<= 1;
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().func_70301_a(i));
            }
            return hash;
        }
    }
}

