/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ItemAction
extends ConfigurableTypeActionForge<ItemConfig, Item> {
    private static final List<ExtendedConfig<?, ?>> MODEL_ENTRIES = Lists.newArrayList();

    @Override
    public void onRegisterForge(ItemConfig eConfig) {
        ItemAction.register(eConfig, () -> {
            this.polish(eConfig);
            eConfig.onForgeRegistered();
            return null;
        });
        if (MinecraftHelpers.isClientSide()) {
            ItemAction.handleItemModel(eConfig);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelRegistryEvent event) {
        for (ExtendedConfig<?, ?> entry : MODEL_ENTRIES) {
            Item item = null;
            Block block = null;
            IModelProviderConfig modelProvider = null;
            if (entry instanceof ItemConfig) {
                item = (Item)((ItemConfig)entry).getInstance();
                modelProvider = (IModelProviderConfig)((Object)entry);
            } else if (entry instanceof BlockConfig) {
                block = (Block)((BlockConfig)entry).getInstance();
                item = ((BlockConfig)entry).getItemInstance();
                modelProvider = (IModelProviderConfig)((Object)entry);
            } else {
                throw new IllegalStateException("An unsupported config was registered to the model loader: " + entry.getNamedId());
            }
            String string = item.getRegistryName().func_110624_b();
        }
    }

    public static void handleItemModel(ExtendedConfig<?, ?> extendedConfig) {
        if (MinecraftHelpers.isClientSide()) {
            MODEL_ENTRIES.add(extendedConfig);
        }
    }

    protected void polish(ItemConfig config) {
        IItemColor itemColorHandler;
        if (MinecraftHelpers.isClientSide() && (itemColorHandler = config.getItemColorHandler()) != null) {
            Minecraft.func_71410_x().getItemColors().func_199877_a(itemColorHandler, new IItemProvider[]{(IItemProvider)config.getInstance()});
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(ItemAction.class);
    }
}

