/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetArrowedListField<E>
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowLeft;
    private ButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public WidgetArrowedListField(FontRenderer fontrenderer, int x, int y, int width, int height, boolean arrows, String narrationMessage, boolean background, List<E> elements) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new ButtonArrow(x, y - 1, "gui.cyclopscore.left", button -> this.decrease(), ButtonArrow.Direction.WEST);
            this.arrowRight = new ButtonArrow(x + width, y - 1, "gui.cyclopscore.right", button -> this.increase(), ButtonArrow.Direction.EAST);
            this.arrowRight.x -= this.arrowRight.getWidth();
        }
        this.func_146185_a(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean func_146181_i() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.func_146180_a("");
        } else {
            this.activeElement = index;
            this.func_146180_a(this.activeElementToString(this.getActiveElement()));
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public boolean setActiveElement(E element) {
        int index = this.elements.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.setActiveElement(index);
        return true;
    }

    protected String activeElementToString(E element) {
        return element.toString();
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.renderButton(mouseX, mouseY, partialTicks);
            this.arrowRight.renderButton(mouseX, mouseY, partialTicks);
            offsetX = this.arrowLeft.getWidth();
            this.x += offsetX + 1;
            this.width -= offsetX * 2;
        }
        super.renderButton(mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.x -= offsetX + 1;
            this.width += offsetX * 2;
        }
    }

    protected void increase() {
        this.setActiveElement((this.activeElement + 1) % this.elements.size());
    }

    protected void decrease() {
        this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.arrowLeft.mouseClicked(mouseX, mouseY, mouseButton) || this.arrowRight.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

