/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;

public class ButtonArrow
extends ButtonExtended {
    private final Direction direction;
    private final Image[] directionImages;

    public ButtonArrow(int x, int y, String narrationMessage, Button.IPressable pressCallback, Direction direction) {
        super(x, y, direction.width, direction.height, narrationMessage, pressCallback, true);
        this.direction = direction;
        this.directionImages = ButtonArrow.getDirectionImage(direction);
    }

    protected static Image[] getDirectionImage(Direction direction) {
        if (direction == Direction.NORTH) {
            return Images.BUTTON_ARROW_UP;
        }
        if (direction == Direction.EAST) {
            return Images.BUTTON_ARROW_RIGHT;
        }
        if (direction == Direction.SOUTH) {
            return Images.BUTTON_ARROW_DOWN;
        }
        if (direction == Direction.WEST) {
            return Images.BUTTON_ARROW_LEFT;
        }
        return null;
    }

    @Override
    protected void drawBackground() {
        this.directionImages[this.getYImage(this.isHovered())].draw((AbstractGui)this, this.x, this.y);
    }

    @Override
    protected void drawButtonInner(int mouseX, int mouseY) {
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum Direction {
        NORTH(15, 10),
        EAST(10, 15),
        SOUTH(15, 10),
        WEST(10, 15);

        private final int width;
        private final int height;

        private Direction(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

