/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;

public class MinimumBlockCountValidator
implements IBlockCountValidator {
    private final int minimumCount;

    @Override
    public ITextComponent isValid(int count, boolean structureComplete, Block block) {
        if (!structureComplete || count >= this.getMinimumCount()) {
            return null;
        }
        return new TranslationTextComponent("multiblock.cyclopscore.error.blockCount.min", new Object[]{this.getMinimumCount(), new TranslationTextComponent(block.func_149739_a(), new Object[0]), count});
    }

    @ConstructorProperties(value={"minimumCount"})
    public MinimumBlockCountValidator(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumBlockCountValidator)) {
            return false;
        }
        MinimumBlockCountValidator other = (MinimumBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMinimumCount() == other.getMinimumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinimumBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinimumCount();
        return result;
    }

    public String toString() {
        return "MinimumBlockCountValidator(minimumCount=" + this.getMinimumCount() + ")";
    }
}

