/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;

public class ExactBlockCountValidator
implements IBlockCountValidator {
    private final int exactCount;

    @Override
    public ITextComponent isValid(int count, boolean structureComplete, Block block) {
        if (!structureComplete || count == this.getExactCount()) {
            return null;
        }
        return new TranslationTextComponent("multiblock.cyclopscore.error.blockCount.exact", new Object[]{this.getExactCount(), new TranslationTextComponent(block.func_149739_a() + ".name", new Object[0]), count});
    }

    @ConstructorProperties(value={"exactCount"})
    public ExactBlockCountValidator(int exactCount) {
        this.exactCount = exactCount;
    }

    public int getExactCount() {
        return this.exactCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExactBlockCountValidator)) {
            return false;
        }
        ExactBlockCountValidator other = (ExactBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getExactCount() == other.getExactCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExactBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExactCount();
        return result;
    }

    public String toString() {
        return "ExactBlockCountValidator(exactCount=" + this.getExactCount() + ")";
    }
}

