/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.relic.ItemRelic;

public abstract class ItemRelicBauble
extends ItemBauble
implements IRelic {
    private final ItemRelic dummy = new ItemRelic(new Item.Properties());

    public ItemRelicBauble(Item.Properties props) {
        super(props);
    }

    public ItemRelic getDummy() {
        return this.dummy;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (entity instanceof PlayerEntity) {
            this.dummy.updateRelic(stack, (PlayerEntity)entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        super.addHiddenTooltip(stack, world, stacks, flags);
        this.dummy.addBindInfo(stacks, stack);
    }

    @Override
    public void bindToUUID(UUID uuid, ItemStack stack) {
        this.dummy.bindToUUID(uuid, stack);
    }

    @Override
    public UUID getSoulbindUUID(ItemStack stack) {
        return this.dummy.getSoulbindUUID(stack);
    }

    @Override
    public boolean hasUUID(ItemStack stack) {
        return this.dummy.hasUUID(stack);
    }

    @Nonnull
    public Rarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.instance().getRelicRarity();
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity ePlayer = (PlayerEntity)entity;
            this.dummy.updateRelic(stack, ePlayer);
            if (this.dummy.isRightPlayer(ePlayer, stack)) {
                this.onValidPlayerWornTick(ePlayer);
            }
        }
    }

    public void onValidPlayerWornTick(PlayerEntity player) {
    }

    @Override
    public boolean canEquip(ItemStack stack, LivingEntity entity) {
        return entity instanceof PlayerEntity && this.dummy.isRightPlayer((PlayerEntity)entity, stack);
    }
}

