/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemLokiRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider,
IManaUsingItem {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";

    public ItemLokiRing(Item.Properties props) {
        super(props);
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || !player.func_225608_bj_()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        BlockRayTraceResult lookPos = ToolCommons.raytraceFromEntity((Entity)player, 10.0, true);
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        if (lookPos.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = lookPos.func_216350_a();
        if (stack.func_190926_b()) {
            BlockPos originCoords = ItemLokiRing.getBindingCenter(lokiRing);
            if (!event.getWorld().field_72995_K) {
                if (originCoords.func_177956_o() == -1) {
                    ItemLokiRing.setBindingCenter(lokiRing, hit);
                    ItemLokiRing.setCursorList(lokiRing, null);
                } else if (originCoords.equals((Object)hit)) {
                    ItemLokiRing.exitBindingMode(lokiRing);
                } else {
                    BlockPos relPos = hit.func_177973_b((Vec3i)originCoords);
                    boolean removed = cursors.remove(relPos);
                    if (!removed) {
                        cursors.add(relPos);
                    }
                    ItemLokiRing.setCursorList(lokiRing, cursors);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        } else {
            int cost = Math.min(cursors.size(), (int)Math.pow(Math.E, (double)cursors.size() * 0.25));
            ItemStack original = stack.func_77946_l();
            int successes = 0;
            for (BlockPos cursor : cursors) {
                BlockPos pos = hit.func_177971_a((Vec3i)cursor);
                if (!ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, false)) continue;
                Vec3d lookHit = lookPos.func_216347_e();
                Vec3d newHitVec = new Vec3d((double)pos.func_177958_n() + MathHelper.func_181162_h((double)lookHit.func_82615_a()), (double)pos.func_177956_o() + MathHelper.func_181162_h((double)lookHit.func_82617_b()), (double)pos.func_177952_p() + MathHelper.func_181162_h((double)lookHit.func_82616_c()));
                BlockRayTraceResult newHit = new BlockRayTraceResult(newHitVec, lookPos.func_216354_b(), pos, false);
                ItemUseContext ctx = new ItemUseContext(player, event.getHand(), newHit);
                ActionResultType result = player.func_184812_l_() ? PlayerHelper.substituteUse(ctx, original.func_77946_l()) : stack.func_196084_a(ctx);
                if (result != ActionResultType.SUCCESS) continue;
                ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, true);
                ++successes;
            }
            if (player instanceof ServerPlayerEntity) {
                LokiPlaceTrigger.INSTANCE.trigger((ServerPlayerEntity)player, lokiRing, successes);
            }
        }
    }

    public static void breakOnAllCursors(PlayerEntity player, Item item, ItemStack stack, BlockPos pos, Direction side) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || player.field_70170_p.field_72995_K || !(item instanceof ISequentialBreaker)) {
            return;
        }
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        boolean dispose = breaker.disposeOfTrashBlocks(stack);
        for (BlockPos offset : cursors) {
            BlockPos coords = pos.func_177971_a((Vec3i)offset);
            BlockState state = player.field_70170_p.func_180495_p(coords);
            breaker.breakOtherBlock(player, stack, coords, pos, side);
            ToolCommons.removeBlockWithDrops(player, stack, player.field_70170_p, coords, s -> s.func_177230_c() == state.func_177230_c() && s.func_185904_a() == state.func_185904_a(), dispose);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity living) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        super.func_77663_a(stack, world, entity, slot, held);
        if (slot >= 0) {
            ItemLokiRing.exitBindingMode(stack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BlockPos> getWireframesToDraw(PlayerEntity player, ItemStack stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return ImmutableList.of();
        }
        RayTraceResult lookPos = Minecraft.func_71410_x().field_71476_x;
        if (lookPos != null && lookPos.func_216346_c() == RayTraceResult.Type.BLOCK && !player.field_70170_p.func_175623_d(((BlockRayTraceResult)lookPos).func_216350_a())) {
            List<BlockPos> list = ItemLokiRing.getCursorList(stack);
            BlockPos origin = ItemLokiRing.getBindingCenter(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.func_177956_o() != -1) {
                    list.set(i, list.get(i).func_177971_a((Vec3i)origin));
                    continue;
                }
                list.set(i, list.get(i).func_177971_a((Vec3i)((BlockRayTraceResult)lookPos).func_216350_a()));
            }
            return list;
        }
        return ImmutableList.of();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getSourceWireframe(PlayerEntity player, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ItemLokiRing.getLokiRing(player) == stack) {
            BlockPos currentBuildCenter = ItemLokiRing.getBindingCenter(stack);
            if (currentBuildCenter.func_177956_o() != -1) {
                return currentBuildCenter;
            }
            if (mc.field_71476_x instanceof BlockRayTraceResult && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && !ItemLokiRing.getCursorList(stack).isEmpty()) {
                return ((BlockRayTraceResult)mc.field_71476_x).func_216350_a();
            }
        }
        return null;
    }

    private static ItemStack getLokiRing(PlayerEntity player) {
        return EquipmentHandler.findOrEmpty(ModItems.lokiRing, (LivingEntity)player);
    }

    private static BlockPos getBindingCenter(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new BlockPos(x, y, z);
    }

    private static void exitBindingMode(ItemStack stack) {
        ItemLokiRing.setBindingCenter(stack, new BlockPos(0, -1, 0));
    }

    private static void setBindingCenter(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.func_177952_p());
    }

    private static List<BlockPos> getCursorList(ItemStack stack) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<BlockPos> cursors = new ArrayList<BlockPos>();
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            CompoundNBT cursorCmp = cmp.func_74775_l(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.func_74762_e(TAG_X_OFFSET);
            int y = cursorCmp.func_74762_e(TAG_Y_OFFSET);
            int z = cursorCmp.func_74762_e(TAG_Z_OFFSET);
            cursors.add(new BlockPos(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, @Nullable List<BlockPos> cursors) {
        CompoundNBT cmp = new CompoundNBT();
        if (cursors != null) {
            int i = 0;
            for (BlockPos cursor : cursors) {
                CompoundNBT cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.func_218657_a(TAG_CURSOR_PREFIX + i, (INBT)cursorCmp);
                ++i;
            }
            cmp.func_74768_a(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static CompoundNBT cursorToCmp(BlockPos pos) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74768_a(TAG_X_OFFSET, pos.func_177958_n());
        cmp.func_74768_a(TAG_Y_OFFSET, pos.func_177956_o());
        cmp.func_74768_a(TAG_Z_OFFSET, pos.func_177952_p());
        return cmp;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/loki_ring");
    }
}

