/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemKingKey
extends ItemRelic
implements IManaUsingItem {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    public static final int WEAPON_TYPES = 12;

    public ItemKingKey(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        ItemStack stack = player.func_184586_b(hand);
        ItemKingKey.setCharging(stack, true);
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int time) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (spawned == 20) {
            ItemKingKey.setCharging(stack, false);
            ItemKingKey.setWeaponsSpawned(stack, 0);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (!(count == this.func_77626_a(stack) || spawned >= 20 || living.field_70170_p.field_72995_K || living instanceof PlayerEntity && !ManaItemHandler.instance().requestManaExact(stack, (PlayerEntity)living, 150, true))) {
            Vector3 look = new Vector3(living.func_70040_Z()).multiply(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.field_70177_z + 90.0f);
            if (look.x == 0.0 && look.z == 0.0) {
                look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.normalize().multiply(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)living)).add(0.0, 1.6, (double)div * 0.1);
            Random rand = living.field_70170_p.field_73012_v;
            Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            Vector3 axis1 = axis.multiply((double)div * 3.5 + 5.0).rotate(rot, look);
            if (axis1.y < 0.0) {
                axis1 = axis1.multiply(1.0, -1.0, 1.0);
            }
            Vector3 end = pl.add(axis1);
            EntityBabylonWeapon weapon = new EntityBabylonWeapon(living, living.field_70170_p);
            weapon.func_70107_b(end.x, end.y, end.z);
            weapon.field_70177_z = living.field_70177_z;
            weapon.setVariety(rand.nextInt(12));
            weapon.setDelay(spawned);
            weapon.setRotation(MathHelper.func_76142_g((float)(-living.field_70177_z + 180.0f)));
            living.field_70170_p.func_217376_c((Entity)weapon);
            weapon.func_184185_a(ModSounds.babylonSpawn, 1.0f, 1.0f + living.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            ItemKingKey.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static boolean isCharging(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
    }

    public static int getWeaponsSpawned(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
    }

    public static void setCharging(ItemStack stack, boolean charging) {
        ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
    }

    public static void setWeaponsSpawned(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/king_key");
    }
}

