/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.lens.Lens;

public class LensMagnet
extends Lens {
    private static final String TAG_MAGNETIZED = "botania:magnetized";
    private static final String TAG_MAGNETIZED_X = "botania:magnetized_x";
    private static final String TAG_MAGNETIZED_Y = "botania:magnetized_y";
    private static final String TAG_MAGNETIZED_Z = "botania:magnetized_z";

    @Override
    public void updateBurst(IManaBurst burst, ThrowableEntity entity, ItemStack stack) {
        BlockPos basePos = new BlockPos((Entity)entity);
        boolean magnetized = entity.getPersistentData().func_74764_b(TAG_MAGNETIZED);
        int range = 3;
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)basePos.func_177982_a(-range, -range, -range), (BlockPos)basePos.func_177982_a(range, range, range))) {
            if (!(entity.field_70170_p.func_175625_s(pos) instanceof IManaReceiver)) continue;
            TileEntity tile = entity.field_70170_p.func_175625_s(pos);
            if (magnetized) {
                int magX = entity.getPersistentData().func_74762_e(TAG_MAGNETIZED_X);
                int magY = entity.getPersistentData().func_74762_e(TAG_MAGNETIZED_Y);
                int magZ = entity.getPersistentData().func_74762_e(TAG_MAGNETIZED_Z);
                if (tile.func_174877_v().func_177958_n() != magX || tile.func_174877_v().func_177956_o() != magY || tile.func_174877_v().func_177952_p() != magZ) continue;
            }
            IManaReceiver receiver = (IManaReceiver)tile;
            BlockPos srcCoords = burst.getBurstSourceBlockPos();
            if (!(tile.func_174877_v().func_177951_i((Vec3i)srcCoords) > 9.0) || !receiver.canReceiveManaFromBursts() || receiver.isFull()) continue;
            Vector3 burstVec = Vector3.fromEntity((Entity)entity);
            Vector3 tileVec = Vector3.fromTileEntityCenter(tile).add(0.0, -0.1, 0.0);
            Vector3 motionVec = new Vector3(entity.func_213322_ci());
            Vector3 normalMotionVec = motionVec.normalize();
            Vector3 magnetVec = tileVec.subtract(burstVec).normalize();
            Vector3 differenceVec = normalMotionVec.subtract(magnetVec).multiply(motionVec.mag() * 0.1);
            Vector3 finalMotionVec = motionVec.subtract(differenceVec);
            if (!magnetized) {
                finalMotionVec = finalMotionVec.multiply(0.75);
                entity.getPersistentData().func_74757_a(TAG_MAGNETIZED, true);
                entity.getPersistentData().func_74768_a(TAG_MAGNETIZED_X, tile.func_174877_v().func_177958_n());
                entity.getPersistentData().func_74768_a(TAG_MAGNETIZED_Y, tile.func_174877_v().func_177956_o());
                entity.getPersistentData().func_74768_a(TAG_MAGNETIZED_Z, tile.func_174877_v().func_177952_p());
            }
            burst.setBurstMotion(finalMotionVec.x, finalMotionVec.y, finalMotionVec.z);
            break;
        }
    }
}

